#include "RunWindow.h"

// This class is where preferences are handled.
// I originally used libprefs by Jon Watte,
// but changed that when R3 came out
// because there wasn't an Intel version
// of libprefs. Now I flatten a BMessage
// into a file to store my settings, which
// works pretty well.

// Window constructor:
// 
RunWindow::RunWindow(const char *path)
	: BWindow(kWindowSiz, kWindowTitle,
	          B_TITLED_WINDOW, B_NOT_V_RESIZABLE | B_NOT_ZOOMABLE)
{
	SetSizeLimits(100.0, 1e9, 0.0, 1e9);
	
	// I keep my settings in an flattened BMessage
	// in a file named after my MIME signature, in 
	// ~/config/settings/. Here I open the file and
	// unflatten the BMessage:
	// 
	BMessage settingsMsg;
	BPath settingsPath;
	if (find_directory(B_COMMON_SETTINGS_DIRECTORY, 
		&settingsPath) == B_OK)
	{
		settingsPath.SetTo(settingsPath.Path(),kSig);
		BFile settingsFile;
		if (settingsFile.SetTo(settingsPath.Path(),
			B_READ_ONLY) == B_OK)
		{
			settingsMsg.Unflatten(&settingsFile);
		}
	}
	
	// set loc to default location:
	BPoint loc = kWindowLoc;
	MoveTo(loc);
	
	// try to read location from settings:
	if (!settingsMsg.FindPoint("loc",&loc))
	{
		// check that window will stay onscreen if moved to new location loc:
		BRect theRect = Frame();
		theRect.OffsetTo(loc);
		BScreen theScreen;
		if ( (theScreen.Frame()).Intersects(theRect) )
			MoveTo(loc);
	}
	
	char text[kCommandLen+1] = "";
	
	// try to read text from settings:
	char *temp;
	if (!settingsMsg.FindString("text",&temp))
		strcpy(text,temp);
	
	// create and add the view (finally!):
	theView = new RunView(text,path);
	AddChild(theView);
}

// Window destructor:

RunWindow::~RunWindow()
{
	// nothing
}

bool RunWindow::QuitRequested(void)
{
	// If running in application mode, quit the application.
	// If running as an add-on, don't quit the Tracker!
	// 
	if (!kAddOn)
		be_app->PostMessage(B_QUIT_REQUESTED);
	
	// I use a flattened BMessage to store my settings.
	// Create the message and stuff the data into it:
	// 
	BMessage settingsMsg;
	const char *text = theView->Text();
	settingsMsg.AddString("text",text);
	settingsMsg.AddPoint("loc",Frame().LeftTop());
	
	// Now, put it into a file in ~/config/settings/.
	// This code might be a bit ugly, because I don't 
	// know the storage kit very well, and I sort of
	// made this up as I wrote it:
	// 
	BPath settingsPath;
	if (find_directory(B_COMMON_SETTINGS_DIRECTORY, 
		&settingsPath) == B_OK)
	{
		settingsPath.SetTo(settingsPath.Path(),kSig);
		BFile settingsFile;
		if (settingsFile.SetTo(settingsPath.Path(),
			B_WRITE_ONLY | B_ERASE_FILE | B_CREATE_FILE) == B_OK)
		{
			settingsMsg.Flatten(&settingsFile);
		}
	}

	return true;
}

void RunWindow::MessageReceived(BMessage *msg)
{
	// The RunView passes kRunMsg to its window
	// after the button is pressed. The window is
	// expected to close itself:
	// 
	if (msg->what == kRunMsg)
		PostMessage(B_QUIT_REQUESTED);
	else BWindow::MessageReceived(msg);
}