#if !defined(RUNVIEW_H)
#define RUNVIEW_H

#include <BeBuild.h>

#include <View.h>
#include <Button.h>
#include <TextControl.h>
#include <Message.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <Dragger.h>
#include <Alert.h>

// misc. constants:

extern const char kAppSig[];
extern const bool kAddOn;

const char kWindowTitle[] = "Run";
const char kButtonText[] = "Run";

const uint32 kRunMsg = 'rUn!';

const int kCommandLen = 1024;
const int kPathLen = 1024;

// sizes and default locations:

const BRect kWindowSiz(0,0,300,35);
const BPoint kWindowLoc(100,100);

const BRect kTextSiz(5,5,250,30);
const BRect kButtonSiz(255,2,298,33);

// RunView class definition
//
// This view contains a BTextControl (text input box) and a button.
// The button sends a message to the view telling it to execute the 
// command in the text control.

#pragma export on // replicant classes must be exported

class RunView : public BView
{
	public:
		RunView(const char *text, const char *path);
		~RunView();
		virtual void AttachedToWindow(void);
		virtual void MessageReceived(BMessage *msg);
		
		void RunCommand(void); // executes the contents of the text field
		const char *Text(void); // returns the contents of the text field
		
		// replication functions; see RunView.cpp for details:
		//
		RunView(BMessage *data);
		virtual status_t Archive(BMessage *data, bool deep = true) const;
		static BArchivable *Instantiate(BMessage *data);
		virtual void AboutRequested(void);
		
	private:
		BTextControl *theTextControl;
		BButton *theButton;
		char thePath[kPathLen+1];
};

#pragma export reset

#endif // RUNVIEW_H