/* terminfo emulation through GNU termcap definitions.

   Copyright (C) 1993-1996 Sebastiano Vigna

    This file is part of ne, the nice editor.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

In other words, you are welcome to use, share and improve this program.
You are forbidden to forbid anyone else to use, share and improve
what you give them.   Help stamp out software-hoarding!  */


#include "termcap.h"

extern char *tparm(const char *cap_string,...);
extern int setupterm(const char *, int, int *);

extern int generic_type;

extern int lines;
extern int columns;

extern char *column_address;
extern char *row_address;

extern char *cursor_address;

extern char *carriage_return;

extern char *cursor_home;
extern char *cursor_to_ll;

extern char *cursor_right;
extern char *cursor_down;
extern char *cursor_left;
extern char *cursor_up;

extern int auto_right_margin;
extern int eat_newline_glitch;

extern char *clr_eos;
extern char *clear_screen;

extern char *bell;
extern char *flash_screen;

extern char *scroll_forward;
extern char *scroll_reverse;

extern char *enter_delete_mode;
extern char *exit_delete_mode;
extern char *enter_insert_mode;
extern char *exit_insert_mode;

extern char *enter_standout_mode;
extern char *exit_standout_mode;
extern int magic_cookie_glitch;
extern int move_standout_mode;

extern char *change_scroll_region;

extern char *insert_line;
extern char *parm_insert_line;
extern char *delete_line;
extern char *parm_delete_line;

extern char *insert_character;
extern char *insert_padding;
extern char *parm_ich;

extern char *delete_character;
extern char *parm_dch;

extern int move_insert_mode;

extern char *save_cursor;
extern char *restore_cursor;

extern char *cursor_invisible;
extern char *cursor_normal;

extern char *init_1string;
extern char *init_2string;
extern char *init_3string;
extern char *enter_ca_mode;
extern char *exit_ca_mode;

extern char *repeat_char;

extern int tilde_glitch;
extern int memory_below;

extern int has_meta_key;
extern char *meta_on;
extern char *meta_off;

extern char *set_window;

extern char *keypad_local;
extern char *keypad_xmit;

extern char *clr_eol;
extern int transparent_underline;

extern char *key_up;
extern char *key_down;
extern char *key_left;
extern char *key_right;

extern char *key_home;
extern char *key_ll;

extern char *key_npage;
extern char *key_ppage;

extern char *key_sf;
extern char *key_sr;


	/* Editing keys */

extern char *key_eol;
extern char *key_eos;
extern char *key_backspace;
extern char *key_dl;
extern char *key_il;
extern char *key_dc;
extern char *key_ic;
extern char *key_eic;
extern char *key_clear;


	/* Keypad keys */

extern char *key_a1;
extern char *key_a3;
extern char *key_b2;
extern char *key_c1;
extern char *key_c3;


	/* Tab keys (never used in the standard configuration) */

extern char *key_catab;
extern char *key_ctab;
extern char *key_stab;


	/* Function keys */

extern char *key_f0;
extern char *key_f1;
extern char *key_f2;
extern char *key_f3;
extern char *key_f4;
extern char *key_f5;
extern char *key_f6;
extern char *key_f7;
extern char *key_f8;
extern char *key_f9;
extern char *key_f10;

extern char *key_f11;
extern char *key_f12;
extern char *key_f13;
extern char *key_f14;
extern char *key_f15;
extern char *key_f16;
extern char *key_f17;
extern char *key_f18;
extern char *key_f19;
extern char *key_f20;
extern char *key_f21;
extern char *key_f22;
extern char *key_f23;
extern char *key_f24;
extern char *key_f25;
extern char *key_f26;
extern char *key_f27;
extern char *key_f28;
extern char *key_f29;
extern char *key_f30;
extern char *key_f31;
extern char *key_f32;
extern char *key_f33;
extern char *key_f34;
extern char *key_f35;
extern char *key_f36;
extern char *key_f37;
extern char *key_f38;
extern char *key_f39;
extern char *key_f40;
extern char *key_f41;
extern char *key_f42;
extern char *key_f43;
extern char *key_f44;
extern char *key_f45;
extern char *key_f46;
extern char *key_f47;
extern char *key_f48;
extern char *key_f49;
extern char *key_f50;
extern char *key_f51;
extern char *key_f52;
extern char *key_f53;
extern char *key_f54;
extern char *key_f55;
extern char *key_f56;
extern char *key_f57;
extern char *key_f58;
extern char *key_f59;
extern char *key_f60;
extern char *key_f61;
extern char *key_f62;
extern char *key_f63;


/* These functions are no-ops in our termcap emulation. */

#define resetterm()
#define fixterm()

/* These are defined in curses.h. The code relies on them. */

#define TRUE 1
#define FALSE 0
