/* Optimal cursor motion definitions.

   Copyright (C) 1985 Free Software Foundation, Inc.
    Based primarily on public domain code written by Chris Torek
    Originally part of GNU Emacs.
    Vastly edited and modified for use within ne.

   Copyright (C) 1993-1996 Sebastiano Vigna

    This file is part of ne, the nice editor.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

In other words, you are welcome to use, share and improve this program.
You are forbidden to forbid anyone else to use, share and improve
what you give them.   Help stamp out software-hoarding!  */


/* This structure holds everything needed to do cursor motion. */

extern struct cm {

	/* Cursor position */

	int	cm_curY,	/* current row */
			cm_curX;	/* current column */
						/* -1 in either one means position unknown */


	/* Capabilities from terminfo */

	char	*cm_up,		/* up (up) */
			*cm_down,	/* down (do) */
			*cm_left,	/* left (bs) */
			*cm_right,	/* right (nd) */
			*cm_home,	/* home (ho) */
			*cm_cr,		/* carriage return (cr) */
			*cm_ll,		/* last line (ll) */
			*cm_abs,	/* absolute (cm) */
			*cm_habs,	/* horizontal absolute (ch) */
			*cm_vabs,	/* vertical absolute (cv) */
			*cm_ds;		/* "don't send" string (ds) */

	int	cm_cols,	/* Number of cols on screen (co) */
			cm_rows;	/* Number of rows on screen (li) */

	unsigned int
			cm_autowrap:1,		/* autowrap flag (am) */
			cm_magicwrap:1,	/* vt100s: cursor stays in last col but
										will wrap if next char is printing (xn) */
			cm_autolf:1,		/* \r performs a \r\n (rn) */
			cm_losewrap:1; 	/* if reach right margin, forget cursor location */


	/* Costs */

	int	cc_up,		/* cost for up */
			cc_down,	/* etc */
			cc_left,
			cc_right,
			cc_home,
			cc_cr,
			cc_ll,
			cc_abs,		/* abs costs are actually min costs */
			cc_habs,
			cc_vabs;
} Wcm;


/* Shorthands */

#define	curY		Wcm.cm_curY
#define	curX		Wcm.cm_curX
#define	Up			Wcm.cm_up
#define	Down		Wcm.cm_down
#define	Left		Wcm.cm_left
#define	Right		Wcm.cm_right
#define	Home		Wcm.cm_home
#define	CR			Wcm.cm_cr
#define	LastLine	Wcm.cm_ll
#define	DontSend	Wcm.cm_ds
#define	AbsPosition	Wcm.cm_abs
#define	ColPosition	Wcm.cm_habs
#define	RowPosition	Wcm.cm_vabs
#define	AutoWrap		Wcm.cm_autowrap
#define	MagicWrap	Wcm.cm_magicwrap
#define	AutoLF		Wcm.cm_autolf
#define	ScreenRows	Wcm.cm_rows
#define	ScreenCols	Wcm.cm_cols

#define	cmat(row,col)	(curY = (row), curX = (col))
#define	cmplus(n)	{if ((curX += (n)) >= ScreenCols && !MagicWrap)\
			   {if (Wcm.cm_losewrap) curY = -1; \
			      else if (AutoWrap) curX = 0, curY++; else curX--;}}

extern int cmputc(int);

#include "debug.h"
