// BitmapStream.h
// © 1998 Matt Lewinski
// Streamable Bitmap (from datatypes library)

#pragma once

#include <Datatypes.h>

class BitmapStream : public BPositionIO
{
public:
					BitmapStream(BBitmap *inMap = NULL);
					~BitmapStream();

	status_t			DetachBitmap(BBitmap * &outMap);
	off_t			Position() const;
	ssize_t			ReadAt(off_t inPos, void *inBuffer, size_t inSize);
	off_t			Seek(off_t inPosition, uint32 inWhence);
	status_t			SetSize(off_t inSize);
	off_t			Size() const;
	ssize_t			WriteAt(off_t inPos, const void *inData, size_t inSize);

protected:
	DATABitmap		mHeader;
	BBitmap *			mMap;
	size_t			mPosition;
	size_t			mSize;
	bool				mDetached;
};