// YColorControlWindow.cpp
// by John Yanarella
// Copyright (c) 1999 John Yanarella, All Rights Reserved

#include <Application.h>
#include <Message.h>
#include <stdio.h>
#include "YColorControlWindow.h"
#include "YColorControl.h"

YColorControlWindow::YColorControlWindow(BPoint leftTop, const char* title, 
					 bool twoSwatches)
   : BWindow(BRect(leftTop.x, leftTop.y, leftTop.x + 260, leftTop.y + 70), title, 
	     B_FLOATING_WINDOW_LOOK, B_FLOATING_APP_WINDOW_FEEL, B_NOT_RESIZABLE|B_NOT_ZOOMABLE)
{
   m_target = NULL;
   m_returnFgMsg = NULL;
   m_returnBgMsg = NULL;
   m_closeMsg = NULL;
	
   BMessage *fgMsg, *bgMsg;
   fgMsg = new BMessage(COLOR_FG_CHG);
   if (twoSwatches)
      bgMsg = new BMessage(COLOR_BG_CHG);
   else
      bgMsg = NULL;
	
   m_colorPicker = new YColorControl(BPoint(0.0,0.0), "", fgMsg, twoSwatches, bgMsg);
   Looper()->Lock();
   m_colorPicker->SetTarget(this, this->Looper());
   AddChild(m_colorPicker);
   Looper()->Unlock();
   Show();	
}

YColorControlWindow::~YColorControlWindow() {
   if (m_returnFgMsg != NULL)
      delete m_returnFgMsg;
   if (m_returnBgMsg != NULL)
      delete m_returnBgMsg;
}

void YColorControlWindow::SetFgColor(rgb_color color) {
   Looper()->Lock();
   if (m_colorPicker)
      m_colorPicker->SetValue(color, true);
   Looper()->Unlock();
}

void YColorControlWindow::SetBgColor(rgb_color color) {
   Looper()->Lock();
   if (m_colorPicker)
      m_colorPicker->SetValue(color, false);
   Looper()->Unlock();
}

void YColorControlWindow::SetSelection(bool foreground) {
   Looper()->Lock();
   m_colorPicker->SetSelection(foreground);
   Looper()->Unlock();
}

void YColorControlWindow::SetTarget(BLooper* target) {
   m_target = target;
}

void YColorControlWindow::SetModificationMessage(BMessage* returnFgMsg, 
						 BMessage* returnBgMsg) {
   m_returnFgMsg = returnFgMsg;
   m_returnBgMsg = returnBgMsg;
}

void YColorControlWindow::SetCloseMessage(BMessage* closeMsg) {
   m_closeMsg = closeMsg;
}

bool YColorControlWindow::QuitRequested()
{
   if (m_target && m_closeMsg)
      m_target->PostMessage(m_closeMsg);
   return(true);
}

void YColorControlWindow::MessageReceived(BMessage* message) {
   switch(message->what) {
   case COLOR_FG_CHG:
      if ((m_target != NULL) && (m_returnFgMsg != NULL)) {
	 rgb_color clr = m_colorPicker->ValueAsColor(true);
			
	 BMessage copy(m_returnFgMsg);
	 copy.AddInt16("red", clr.red);
	 copy.AddInt16("green", clr.green);
	 copy.AddInt16("blue", clr.blue);
				
	 m_target->PostMessage(&copy);
      }
      break;		
   case COLOR_BG_CHG:
      if ((m_target != NULL) && (m_returnBgMsg != NULL)) {
				
	 rgb_color clr = m_colorPicker->ValueAsColor(false);
				
	 BMessage copy(m_returnBgMsg);
	 copy.AddInt16("red", clr.red);
	 copy.AddInt16("green", clr.green);
	 copy.AddInt16("blue", clr.blue);
			
	 m_target->PostMessage(&copy);
      }
      break;
   default:
      BWindow::MessageReceived(message);
      break;
   }
}
