// YColorControl.h
// by John Yanarella
// Copyright (c) 1999 Cre@tive Element, All Rights Reserved

#ifndef Y_COLOR_CONTROL_H
#define Y_COLOR_CONTROL_H

#include <View.h>
#include <TextControl.h>

class YColorControl : public BControl 
{
public:
   YColorControl(BPoint leftTop, const char *name, BMessage *fgMessage = NULL, 
		 bool twoSwatches = false, BMessage *bgMessage = NULL);
   ~YColorControl();
	
   virtual void AttachedToWindow();
	
   virtual void MouseDown(BPoint point);
   virtual void Draw(BRect updateRect);
   virtual void MessageReceived(BMessage* message);
	
   //virtual void SetValue(int32 color);
   void SetValue(rgb_color color, bool foreground = true);
   rgb_color ValueAsColor(bool foreground = true);
	
   virtual void SetEnabled(bool enabled);
	
   // f/b selection: (true = foreground, false = background)
   void SetSelection(bool foreground);
		
private:
   // utility drawing methods - NOTE: all assume view is locked!
   void DrawBox(BRect rect, bool selected = false);
   void DrawFilledBox(BRect rect, rgb_color &color, bool selected = false);
   void DrawShadedTriangle(BPoint point);

   // data update methods
   void UpdateOffscreen();
   void UpdateTextFields();
   void UpdateValues();
	
   // message model for second message (sent when background selected)
   BMessage* m_bgMessage;
	
   // the colors
   rgb_color m_foreground;
   rgb_color m_background;
	
   // f/b selection: (true = foreground, false = background)
   bool m_selected;
	
   // number of swatches: (true = two, false = one) 
   bool m_twoSwatches;

   // color picker visual components
   BBitmap* m_image;
   BView* m_offscreenView;
   BTextControl *rBTC, *gBTC, *bBTC;
};

#endif //Y_COLOR_CONTROL_H
