// RouteApp.cpp
// e.moon 14may99

#include "RouteApp.h"
#include "RouteWindow.h"
#include "DormantNodeWindow.h"

#include "NodeManager.h"
#include "TipManager.h"

#include <Debug.h>
#include <OS.h>

extern "C" void SetNewLeakChecking(bool);
extern "C" void SetMallocLeakChecking(bool);

__USE_CORTEX_NAMESPACE

const char* const		RouteApp::s_appSignature = "application/x-vnd.MeadGroup-Cortex";

// -------------------------------------------------------- //
// ctor/dtor
// -------------------------------------------------------- //

RouteApp::~RouteApp() {
//	PRINT((
//		"RouteApp::~RouteApp()\n"));

	ASSERT(manager);
	thread_id id = manager->Thread();
	manager->release();
	
//	PRINT((
//		"- waiting for manager to die\n"));
	if(id >= B_OK) {
		status_t err;
		while(wait_for_thread(id, &err) == B_INTERRUPTED) {
			PRINT((" * RouteApp::~RouteApp(): B_INTERRUPTED\n"));
		}
	}
//	PRINT((
//		"- RouteApp done.\n"));

}

RouteApp::RouteApp() :
	BApplication(s_appSignature),
	manager(new NodeManager) {
	
	m_routeWindow = new RouteWindow(manager);
}

bool RouteApp::QuitRequested() {

	// [e.moon 20oct99] make sure the main window is dead before quitting
	
	// store window positions & other settings
	app_info ai;
	status_t err = GetAppInfo(&ai);
	ASSERT(err == B_OK);

	BFile appFile(&ai.ref, B_READ_WRITE);	
	m_routeWindow->_archiveSettings(&appFile);

	m_routeWindow->_closeInspectors();
	m_routeWindow->Lock();
	m_routeWindow->Quit();
	
	// clean up the TipManager [e.moon 19oct99]
	TipManager::QuitInstance();

	return true;
}

// -------------------------------------------------------- //
// main() stub
// -------------------------------------------------------- //

int main() {
//	SetNewLeakChecking(true);
//	SetMallocLeakChecking(true);
	
	RouteApp app;
	app.Run();
	return 0;
}

// END -- RouteApp.cpp --
