// RoutingRow.h
// e.moon 7may99 (MediaRoutingView)
//
// PURPOSE
//   Base class for the specific MediaRoutingView row
//   types (GutterRow and NodeRow, so far.)
//   Stores a list of wire segments touching or crossing
//   this row, for fast wire lookup.
//
// HISTORY
//   e.moon	7may99:	created

#ifndef __ROUTINGROW_H__
#define __ROUTINGROW_H__

#include <list>

#include "GridRow.h"
#include "WireSegment.h"

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class RoutingRow :
	public		GridRow {

public:
	virtual ~RoutingRow() {}
	RoutingRow(
		float		height=0.0,
		int32		flags=0) : GridRow(height, flags) {}

public:					// segment operations	
	const list<WireSegment>& segments() const { return m_segments; }	
	bool removeSegment(const WireSegment& segment) {
		uint32 n = m_segments.size();
		m_segments.remove(segment);
		return (n - m_segments.size()) != 0;
	}

public:					// members [+++++ should NOT be public]
	// all wire segments touching this row
	list<WireSegment>		m_segments;
};


__END_CORTEX_NAMESPACE
#endif /* __ROUTINGROW_H__ */
