// inspector_layout.h

#ifndef __inspector_layout_H__
#define __inspector_layout_H__

#include <Menu.h>
#include <Font.h>

inline float _menu_width(
	const BMenu* menu,
	const BFont* font) {

	float max = 0.0;
	
	int total = menu->CountItems();
	for(int n = 0; n < total; ++n) {
		float w = font->StringWidth(
			menu->ItemAt(n)->Label());
		if(w > max)
			max = w;
	}
	
	return max;
}

#endif /*__inspector_layout_H__*/