// InspectorWindow.cpp

#include "InspectorWindow.h"
#include "RouteWindow.h"
#include "GroupInspector.h"

#include <View.h>

__USE_CORTEX_NAMESPACE

// -------------------------------------------------------- //
// *** ctors/dtor
// -------------------------------------------------------- //

InspectorWindow::~InspectorWindow() {}
	
InspectorWindow::InspectorWindow(
	NodeManager*						manager,
	RouteWindow*						routeWindow,
	const char*							name,
	BView*									inspector) :
	BWindow(
		BRect(200,200,200,200),
		name,
		B_FLOATING_WINDOW_LOOK, B_FLOATING_APP_WINDOW_FEEL,
		B_WILL_ACCEPT_FIRST_CLICK|B_AVOID_FOCUS|B_NOT_ZOOMABLE|B_ASYNCHRONOUS_CONTROLS),
	m_inspector(inspector),
	m_routeWindow(routeWindow) {
	
	AddChild(m_inspector);

//	m_inspector = new GroupInspector(
//		manager,
//		"groupInspector");
//	
//	ResizeTo(
//		m_inspector->Bounds().Width(),
//		m_inspector->Bounds().Height());
}

BMessenger InspectorWindow::inspector() const {
	return BMessenger(m_inspector);
}

BView* InspectorWindow::view() const {
	return m_inspector;
}

BMessenger InspectorWindow::routeWindow() const {
	return BMessenger(m_routeWindow);
}

// -------------------------------------------------------- //
// *** BWindow
// -------------------------------------------------------- //

bool InspectorWindow::QuitRequested() {
	BMessage m(RouteWindow::M_INSPECTOR_CLOSED);
	m.AddPointer("inspector", (void*)this);
	m.AddRect("frame", Frame());
	BMessenger(m_routeWindow).SendMessage(&m);
	return true;
}

// END -- InspectorWindow.cpp --
