// InspectorManager.h
// * PURPOSE
//   Given node-selection messages, launches node- and group-
//   inspector windows as necessary.
//
// * HISTORY
//   e.moon		24aug99		Begun

#ifndef __InspectorManager_H__
#define __InspectorManager_H__

#include <list>

#include <Handler.h>

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class InspectorManager :
	public	BHandler {
	typedef	BHandler _inherited;

public:											// *** messages
	enum message_t {
		// INBOUND: notifies the manager that node and/or group
		//          inspectors need to be activated
		// nodeID: int32
		M_NODE_SELECTED					= InspectorManager_message_base,
		
		// INBOUND:
		// acceptible replies to SELECT_ commands:
		M_SELECTED,
		M_REFUSED,
		
		// INBOUND:
		// sent on shutdown
		// groupID: int32 [or]
		// nodeID: int32
		M_GROUP_INSPECTOR_CLOSED,
		M_NODE_INSPECTOR_CLOSED,

		// OUTBOUND: sent to NodeInspector
		// nodeID: int32
		M_SELECT_NODE,
		
		// OUTBOUND: sent to GroupInspector
		// groupID: int32
		M_SELECT_GROUP
	};
	
public:											// *** ctor/dtor
	virtual ~InspectorManager();
	InspectorManager(); //nyi
	
public:											// *** BHandler
	virtual void MessageReceived(
		BMessage*								message); //nyi
		
private:
	typedef list<BMessenger> messenger_list;
	
	// group inspector
	BMessenger								groupInspector;
	
	// set of node inspectors
	messenger_list						nodeInspectors;
};

__END_CORTEX_NAMESPACE
#endif /*__InspectorManager_H__*/