// InspectorManager.cpp

#include "InspectorManager.h"

#include "InspectorWindow.h"
#include "GroupInspector.h"

#include <Debug.h>

__USE_CORTEX_NAMESPACE

// -------------------------------------------------------- //
// *** ctor/dtor
// -------------------------------------------------------- //

InspectorManager::~InspectorManager() {}
InspectorManager::InspectorManager() :
	BHandler("InspectorManager") {}
	
// -------------------------------------------------------- //
// *** BHandler
// -------------------------------------------------------- //

void InspectorManager::MessageReceived(
	BMessage*								message) {

	uint32 id;
	status_t err;

	switch(message->what) {
		case M_NODE_SELECTED:
			err = message->FindInt32("nodeID", (int32*)&id);
			if(err < B_OK) {
				PRINT((
					"* InspectorManager::MessageReceived(M_NODE_SELECTED):\n"
					"  no nodeID!\n"));
				break;
			}

			_handleNodeSelected(id);
			break;

		case M_GROUP_INSPECTOR_CLOSED:
			err = message->FindInt32("groupID", (int32*)&id);
			if(err < B_OK) {
				PRINT((
					"* InspectorManager::MessageReceived(M_GROUP_INSPECTOR_CLOSED):\n"
					"  no groupID!\n"));
				break;
			}
			
			_handleGroupInspectorClosed(id);
			break;
			
		case M_NODE_INSPECTOR_CLOSED:
			err = message->FindInt32("nodeID", (int32*)&id);
			if(err < B_OK) {
				PRINT((
					"* InspectorManager::MessageReceived(M_NODE_INSPECTOR_CLOSED):\n"
					"  no nodeID!\n"));
				break;
			}
			
			_handleNodeInspectorClosed(id);
			break;
			
		default:
			_inherited::MessageReceived(message);
	}	
}

// -------------------------------------------------------- //
// implementation
// -------------------------------------------------------- //

void InspectorManager::_handleNodeSelected(
	uint32									nodeID) {

		
}
	
void InspectorManager::_handleGroupInspectorClosed(
	uint32									groupID); //nyi

void InspectorManager::_handleNodeInspectorClosed(
	uint32									nodeID); //nyi


// END -- InspectorManager.cpp --