// GroupInspectorWindow.cpp

#include "GroupInspectorWindow.h"
#include "GroupInspector.h"

__USE_CORTEX_NAMESPACE

// -------------------------------------------------------- //
// *** ctors/dtor
// -------------------------------------------------------- //

GroupInspectorWindow::~GroupInspectorWindow() {}
	
GroupInspectorWindow::GroupInspectorWindow(
	NodeManager*						manager) :
	BWindow(
		BRect(200,200,200,200),
		"Group Inspector",
		B_FLOATING_WINDOW_LOOK, B_FLOATING_APP_WINDOW_FEEL,
		B_WILL_ACCEPT_FIRST_CLICK|B_AVOID_FOCUS|B_NOT_CLOSABLE|B_NOT_ZOOMABLE) {

	m_groupInspector = new GroupInspector(
		manager,
		"groupInspector");
	AddChild(m_groupInspector);
	ResizeTo(
		m_groupInspector->Bounds().Width(),
		m_groupInspector->Bounds().Height());
}

BMessenger GroupInspectorWindow::inspector() const {
	return BMessenger(m_groupInspector);
}

// -------------------------------------------------------- //
// *** BWindow
// -------------------------------------------------------- //

bool GroupInspectorWindow::QuitRequested() {
	return true;
}

// END -- GroupInspectorWindow.cpp --