// DormantNodeListItem.h
// e.moon 2jun99
//
// RESPONSIBILITIES
// - represent a single dormant (add-on) media node in a
//   list view.

#ifndef __DormantNodeListItem_H__
#define __DormantNodeListItem_H__

#include <ListItem.h>
#include <MediaAddOn.h>
#include <Font.h>
#include <Bitmap.h>
#include <Locker.h>

#include <map>
#include <vector>

class BTranslatorRoster;

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class DormantNodeView;

class DormantNodeListItem :
	public		BListItem {
	typedef	BListItem _inherited;
	
public:				// ctor/dtor
	virtual ~DormantNodeListItem();
	DormantNodeListItem(const dormant_node_info& info);

	const dormant_node_info& info() const { return m_info; }

protected:			// internal operations
	// count flavors, init icons
	void initFlavorInfo();

public:
	static void DrawBackground(
		BView* pOwner, BRect frame);

public:				// ListItem impl.
	virtual void DrawItem(
		BView* pOwner, BRect frame,	bool complete=false);

	virtual void Update(
		BView* pOwner, const BFont* pFont);
		
private:				// members
	dormant_node_info			m_info;
	dormant_flavor_info		m_flavorInfo;
	
	// presentation
	const BFont* 			m_pFont;
	font_height				m_fontHeight;
	
	vector<BBitmap*>		m_icons;

public:
	// [7oct99 e.moon] made xres-friendly
	enum icon_id {
		AUDIO_PRODUCER_ICON			= 1000,
		AUDIO_CONSUMER_ICON,
		VIDEO_PRODUCER_ICON,
		VIDEO_CONSUMER_ICON
	};
	
	typedef map<icon_id, BBitmap*> icon_map;
	
	static const uint16		s_iconCount;

private:				// bitmap management
	static BBitmap* GetIcon(icon_id id);
	static void LoadIcons();
	static void DoLoad(icon_id id);

	static bool						s_iconCacheLoaded;
	static icon_map			s_iconCache;
	static BLocker				s_iconCacheLock;
	
private:				// display constants
	static const float				s_iconWidth;
	static const float				s_iconHeight;
	static const float				s_iconPadX;
	static const float				s_iconPadTop;
	static const float				s_iconPadBottom;
	static const float				s_textPadX;

	static const rgb_color		s_iconBackColor;
	static const rgb_color		s_textBackEdgeColor;
	static const rgb_color		s_textBackColor;
	static const rgb_color		s_textColor;
	static const rgb_color		s_sel_textBackColor;
	static const rgb_color		s_sel_textColor;
};

__END_CORTEX_NAMESPACE
#endif /*__DormantNodeListItem_H__*/
