// BookwormApplication.cpp
// Copyright 1997 by Brad Ackerman.  All Rights Reserved.

#include "Bookworm.h"
#include "BookwormWindow.h"
#include "BookwormConverter.h"
#include "BookwormConsts.h"

void main (void) {
	BookwormApplication		myApplication;
	
	myApplication.Run();
}

BookwormApplication::BookwormApplication (void)
		: BApplication("application/x-vnd.SonicScrewdriver-Bookworm") {
	
	BookwormWindow			*aWindow;
	BRect					aRect;
	
	// it's window time!
	aRect.Set(100, 80, 400, 300);
	aWindow = new BookwormWindow(aRect);

	converter = new BookwormConverter(aWindow);	// create converter thread
	aWindow->Show();								// make window visible
}

void BookwormApplication::RefsReceived(BMessage *event) {
	uint32		type;
	int32		count, i;
	BMessage	*msg;
	entry_ref	*ref;
		
	// got some files from the Open dialog to process
	event->GetInfo("refs", &type, &count);
	for (i = 0; i < count; i++ ) {
		ref = new entry_ref;
		msg = new BMessage(PROCESS_HTML);
		event->FindRef("refs", i, ref);
		msg->AddRef("ref", ref);
		converter->PostMessage(msg);
		delete ref;
		delete msg;
	}
}

BookwormApplication::~BookwormApplication() {
	// kill converter thread
	converter->Lock();
	converter->QuitRequested();
}

void BookwormApplication::MessageReceived(BMessage *event) {
	
	switch (event->what) {
		case BOOKMARK_DEST_SPECIFIED:
			// pass message to converter thread
			converter->PostMessage(event);
			break;
		default:
			inherited::MessageReceived(event);
			break;
	}
}
