#include <InterfaceKit.h>
#include <AppKit.h>
#include <Beep.h>

#include "bdh_view.h"


const char *app_signature = "application/x-vnd.Be-BDH";


/****************************************************/


class bdh_window : public BWindow
{
public:
	bdh_window(BRect r);
virtual bool QuitRequested();
virtual void MessageReceived(BMessage*);
};


bdh_window::bdh_window(BRect r)
	: BWindow(r, "BDH Calc ", B_TITLED_WINDOW, B_NOT_ZOOMABLE | B_NOT_RESIZABLE)
{
	bdh_view *theView = new bdh_view(Bounds(), "bdh_view");
	AddChild(theView);
}


bool bdh_window::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
}

void bdh_window::MessageReceived(BMessage *msg)
{
	//if (msg->what == BDHVIEW_UINT64)
	//	beep();
	inherited::MessageReceived(msg);
}

/****************************************************/


class bdh_app : public BApplication
{
public:
	bdh_app(const char *signature);
};


bdh_app::bdh_app(const char *signature)
	: BApplication(signature)
{
	BRect r(187, 229, 187+298, 229+126);
	bdh_window *theWindow = new bdh_window(r);
	theWindow->Show();
}


/****************************************************/


main()
{
	new bdh_app(app_signature);

	be_app->Run();
	delete be_app;
}

