/*
 * acquire.c - acquire a semaphore
 *
 * Copyright (C) 1997 Chris Herborth (chrish@qnx.com)
 *
 * This is the mirror image of /bin/release; it'll attempt to acquire the
 * specified semaphore.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <be/kernel/OS.h>

#define DEBUG 1

void usage( void );

void usage( void )
{
	printf( "acquire [-w] [-c count] semaphore_number\n" );
	printf( "\n" );
	printf( "\t-c count\tacquire the semaphore ``count'' times\n" );
	printf( "\t-w\twait until the semaphore can be acquired\n" );
	printf( "\t\t(default timeout is 5 seconds)\n" );
	printf( "\n" );
	printf( "warning: this can be hazardous...\n" );

	exit( EXIT_FAILURE );
}

int main( int argc, char **argv )
{
	status_t retval;

	int wait_for_acquire = 0;
	int count = 1;
	sem_id sem_num = 0;

	int i;

	/* Check our command-line args.  This isn't that hot, it won't bother */
	/* to warn you if you're silly and specified some bogus args.         */
	if( argc < 2 ) {
		printf( "%s: you must specifiy a semaphore\n\n", argv[0] );
		usage();
	}

	for( i = 1; i < argc; i++ ) {
		if( !strcmp( argv[i], "-w" ) ) {
			wait_for_acquire = B_TIMEOUT;
		} else if( !strcmp( argv[i], "-c" ) ) {
			count = atoi( argv[i+1] );

			if( count <= 0 ) {
				printf( "%s: invalid count (%d, from %s)\n\n", argv[0], 
					    count, argv[i+1] );
				usage();
			}

			i++;
		} else {
			sem_num = (sem_id)atoi( argv[i] );

			if( sem_num <= 0 ) {
				printf( "%s: invalid semaphore (%d)\n\n", argv[0], sem_num );
				usage();
			}
		}
	}

	/* Now whack that semaphore. */
	retval = acquire_sem_etc( sem_num, count, wait_for_acquire,
							  (bigtime_t)( 5 * 60 * 1000 ) );
	if( retval == B_BAD_SEM_ID ) {
		printf( "%s: %d is not a valid semaphore\n", argv[0], sem_num );
	} else if( retval == B_BAD_VALUE ) {
		printf( "%s: %d is not a valid count\n", argv[0], count );
	} else if( retval == B_WOULD_BLOCK ) {
		printf( "%s: semaphore %d is not available\n", argv[0], sem_num );
	} else if( retval == B_TIMED_OUT ) {
		printf( "%s: timed out waiting for semaphore %d\n", argv[0], sem_num );
	}

	return EXIT_SUCCESS;
}
