//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: "Hash.h"

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	A Hash table for holding ‘iconified’ text

	(Feel free to use Hash.h and Hash.cpp in your
	own programs..)
*/
//====//====//====//====//====//====//====//====//====//====//

#ifndef HASH_H
	#define HASH_H

	enum HTYPE{
		HNORM=0,            // Normal text
		HSTRING,            // "strings"
		HCCOMMENT,          // //  style comments
		HCTOKEN,            // C and C++ tokens
		HOPERATOR,          // C-style operators
		HUNDEFINED=5,       //    future use
		HINTEGER,           // 1   2   3
		HFLOAT,             // 1.0 2.0 3.0
		HFIND,              // the 'find' string (unimplemented)
		HBASHCOMMENT,       // # BASH comments
		HMAILEVEN=10,       // >> Even Emaillers
		HMAILODD,           // >>> Odd Emaillers
		HURL,               // http://www.url.net (not implemented yet)
		HHTMLTAGON,         // <HtmlTag>
		HHTMLTAGOFF,        // </HtmlTag>
		HHTMLTRIGRAPH=14,   //  &gt; HTML &lt;
		/* 15..63 undefined.. */
		HASHMAX=63
	};

	extern HTYPE QuickCheck(char *text,int length);
	extern HTYPE FindString(char *text,int32 length,int32 &start,int32 &finish,int32 flags=0);

/*
	Sample Code:

	extern void DrawStyledString(char *source,int32 length,HTYPE style);

	void OutputString(char *source){
		int32 length=strlen(source); //used below
		int32 start,finish;  //filled in by FindString

		//for a performance boost, remove leading spaces here...

		HTYPE style=FindString(source,length,start,finish);

		if (start>0)
			DrawColoredString(source,start-1,HNORM);

		if (finish>start)
			DrawColoredString(source+start,finish-start,style);

		if (finish<length)
		   OutputString(source+finish); //Warning: Recursion
	}

*/


#endif
