//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “BufList.cpp”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	A list of buffer Names for the 'Doc List' Menu.
	Organised this way to prevent deadlocks.
*/
//====//====//====//====//====//====//====//====//====//====//
#include <stdio.h>
#include <string.h>
#include <Autolock.h>

#include "cb_list.h"
#include "Yate.h"
#include "BufList.h"

BufList *gb=NULL;

BufList::BufList():BLocker("BufList"){
	gb=this;
	bf=new CList();
	nl=new CList();
	cnt=0;
}

BufList::~BufList(){
}

Buff *BufList::BuffAt(int32 index){
	return index<cnt?(Buff*)bf->Item(index):NULL;
}
char *BufList::NameAt(int32 index){
	return index<cnt?(char*)nl->Item(index):NULL;
}


void BufList::SetBuff(int32 index,Buff*bb){
//	printf("aw %d,%x\n",index,bb);
	bf->SwapWith(bb,index);
}
void BufList::SetName(int32 i,const char *name){
	char *s=(char*)nl->Item(i);
//	printf("Name Set (%d),(%x),(%s),%d\n",i,s,name,strlen(name));
	if (!s)s=(char*)malloc(256);
	strcpy(s,name);
	nl->SwapWith(s,i);
}
