//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “ViewHex.cpp”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	A Hex-Viewer module
*/
//====//====//====//====//====//====//====//====//====//====//

#include "ViewBase.h"
#include "NTree.h"

#include <View.h>

#include <stdio.h> //sprintf

void ViewBase::LocHex(float &x,float &y,int place){
	float em=vv->StringWidth("W");
	place--;
	y=((place)/8)*fh;
	x=((place)&7)*em*3+em*6+4+3;
}

void ViewBase::DrawHex(BRect dest,float tlx,float tly){
	vv->SetLowColor(0,0,0,0);
	vv->SetHighColor(255,255,255,255);
//    FillRect(dest,B_SOLID_LOW);
	vv->SetDrawingMode(B_OP_COPY);
//    vv->SetFont(&myfont);

	float em=vv->StringWidth("W");

	int stt=floor((dest.top+tly)/fh)-1;
	int fin=floor((dest.bottom+tly)/fh);
	float y1=(stt+1)*fh-tly,y2=y1+fh-1,xx=em*6+4-tlx;
	int vmax=nt->Size()-2;
	for (int i=stt;i<=fin;i++){
		if (i<fin){
			vv->FillRect(BRect(0,y1,xx-1,y2),B_SOLID_LOW);
			vv->FillRect(BRect(xx+1,y1,xx+24*em-1,y2),B_SOLID_LOW);
			vv->FillRect(BRect(xx+24*em+1,y1,40000,y2),B_SOLID_LOW);
			vv->StrokeLine(BPoint(xx,y1),BPoint(xx,y2));
			vv->StrokeLine(BPoint(xx+24*em,y1),BPoint(xx+24*em,y2));
		}
		if (i>=stt && i>=0){
			char sha[16],spa[32];
			sprintf(sha,"%X",i*8);
			float ww=vv->StringWidth(sha);
			vv->DrawString(sha,BPoint(xx-2-ww,y1));
			nt->Fetch(spa,8,i*8+1);
			int max=vmax-i*8;
			if (max>8)max=8;
			for (int j=0;j<max;j++){
				sprintf(sha,"%02X",spa[j]&255);
				vv->DrawString(sha,BPoint(xx+3+j*em*3,y1));
				vv->DrawChar(spa[j],BPoint(xx+3+(24+j)*em,y1));
			}
		}
		y1+=fh;
		y2+=fh;
	}
	xx+=20*em;

}
