//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “ViewBase.cpp”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	Place-Holder until I develop a better structured interface
	between the drawing routines and the drawing modules.
*/
//====//====//====//====//====//====//====//====//====//====//

#include "ViewBase.h"
#include "NTree.h"
#include "UBuffer.h"

#include <View.h>
#include <stdio.h>


ViewBase::ViewBase(){
}

void ViewBase::Target(BView *_vv,float _fh,float _ffh,float _width,Buff *_cb){
	vv=_vv;
	fh=_fh;
	ffh=_ffh;
	cb=_cb;
	width=_width;
	nt=cb->mytree;
}


void ViewBase::Draw(BRect dest,float tlx,float tly){
	switch (vmode){
		case 0:DrawHex(dest,tlx,tly);break;
		case 3:DrawHTML(dest,tlx,tly);break;

		default:DrawTxt(dest,tlx,tly);break;
	}
}

void ViewBase::Locate(float &x,float &y,int place){
	switch (vmode){
		case 0:LocHex(x,y,place);break;
		case 3: //html
			x=0;y=0;
			break;
		default:LocTxt(x,y,place);break;
	}
}
float ViewBase::LocateY(int place){
	switch (vmode){
        case 0:
			{
				float x,y;
				LocHex(x,y,place);
				return y;
			}
			break;
		case 3:
			return 0;
		default:return LocTxtY(place);break;
	}
	return 0;
}

void ViewBase::Locate2(int &x,int &y,int place){
	switch (vmode){
//        case 0:LocHex(x,y,place);break;
		default:LocTxt2(x,y,place);break;
	}
}

void ViewBase::SHC(const rgb_color &n){
	vv->SetHighColor(n);
}


//index_for_color(j,j,j);


int ViewBase::Place(float x,float y){
//    BAutolock(nt);

	int p1=0;
	int p2=nt->Size();
	int stp=0;
	int  lm=-1;
	float xx=0,yy=0;
	float lx=1000.0,ly=-1;
	while (p2>p1){
		int mm=p1+p2>>1;
		if (mm==lm){p2--;}
		Locate(xx,yy,mm);
		if (yy<y){
			if (yy>y-fh){
				((xx<x)?p1:p2)=mm;
			}else{
				p1=mm;
			}
		}else{
			p2=mm;
		}
		if (stp++>50){
			printf("big file %d,%d\n",p1,p2);
			break;
		}
		lm=mm;
		lx=xx;
		ly=yy;
	}

	Locate(xx,yy,p1+1);
	if (ly==yy && (x-xx>lx-x))p1++;
	
	return p1;

}

