//MyApp.cpp

#include "preferences.h"
#include "myRoColor.h"
#include "myApp.h"
#include "myButtonGadg.h"
#include "intGadg.h"
#include "myButtonGadgA.h"
#include "warning.h"
#include "fontData.h"
#include "layoutMatrix.h"
#include "colorWellGadg.h"
#include "windowGuts.h"
#include "mainWindow.h"
#include "prefWindow.h"
#include "memory"

MyApp	::	MyApp()
		:	BApplication("application/x-EFM5-WordWrap"),
			preferredFont(new BFont()),
			appsPreferences("x-EFM5-WordWrap"),
			appsPreferenceSet(	appsPreferences,  
								"hierarchical/extendable/settings", 
								true),
			bPrefChangesMade(false),
			pMainWindow(NULL),
			pPrefWindow(NULL)
{
	if (appsPreferences.InitCheck())
	{
		puts("Cannot initialize preferences");
		exit(1);
	}
	if (appsPreferenceSet.InitCheck())
	{
		puts("Cannot get settings");
		exit(2);
	}
	BRect	screenResolutionRect;
	{//if screen is on stack do I want it in app's scope, or should I do like this so it goes away fast?
		BScreen	screen(B_MAIN_SCREEN_ID);
		if(!screen.IsValid()) 
		{//may not be valid, if not, this is not a critical app--bail out as best we can
			printf("!screen.IsValid()\n");
			return;
		}
		screenResolutionRect = screen.Frame();
	}
	//following is a bunch of prefs stuff set to default if file not found:
	FontData fontData;
	const void * fontPrefData;
	size_t fontPrefSize;
	uint32 fontPrefType = '    ';
	if (	appsPreferenceSet.GetData(	"FONTDATAPREFERENCE_TYPE", 
										fontPrefData, 
										fontPrefSize, 
										fontPrefType) 
			|| 
			(fontPrefType != FONTDATAPREFERENCE_TYPE))
	{
		BFont * tempBFont = new BFont();
		SetPreferredFont(tempBFont);
		delete tempBFont;
	}
	else
	{
		memcpy(	&fontData, 
				fontPrefData, 
				fontPrefSize);
		SetPreferredFontFromData(&fontData);
	}
	uint32 prefWrapAt;
	const void * prefWrapAtData;
	size_t prefWrapAtSize;
	uint32 prefWrapAtType = '    ';
	if (	appsPreferenceSet.GetData(	"preferredWrapAt", 
										prefWrapAtData, 
										prefWrapAtSize, 
										prefWrapAtType) 
			|| 
			(prefWrapAtType != B_UINT32_TYPE))
	{
		SetPreferredWrapAt(60);
	}
	else
	{
		memcpy(	&prefWrapAt, 
				prefWrapAtData, 
				prefWrapAtSize);
		SetPreferredWrapAt(prefWrapAt);
	}
	rgb_color prefsColor;
	const void * prefsColorData;
	size_t prefsColorSize;
	uint32 prefsColorType = '    ';
	if (	appsPreferenceSet.GetData(	"PreferredHighColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 23;
		prefsColor.green = 223;
		prefsColor.blue = 23;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredLowColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 43;
		prefsColor.green = 43;
		prefsColor.blue = 243;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredViewColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 23;
		prefsColor.green = 123;
		prefsColor.blue = 12;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredIntGadgetHighColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 22;
		prefsColor.green = 22;
		prefsColor.blue = 223;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredIntGadgetHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredIntGadgetLowColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 43;
		prefsColor.green = 243;
		prefsColor.blue = 43;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredIntGadgetLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredIntGadgetViewColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 223;
		prefsColor.green = 123;
		prefsColor.blue = 13;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredIntGadgetViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredColorWellGadgetHighColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 212;
		prefsColor.green = 22;
		prefsColor.blue = 223;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredColorWellGadgetHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredColorWellGadgetLowColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 143;
		prefsColor.green = 243;
		prefsColor.blue = 43;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredColorWellGadgetLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredColorWellGadgetViewColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 223;
		prefsColor.green = 123;
		prefsColor.blue = 113;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredColorWellGadgetViewColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyButtonGadgetHighColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 212;
		prefsColor.green = 22;
		prefsColor.blue = 223;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredMyButtonGadgetHighColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyButtonGadgetLowColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 143;
		prefsColor.green = 243;
		prefsColor.blue = 43;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredMyButtonGadgetLowColor(&prefsColor);
	if (	appsPreferenceSet.GetData(	"PreferredMyButtonGadgetViewColor", 
										prefsColorData, 
										prefsColorSize, 
										prefsColorType) 
			|| 
			(prefsColorType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 223;
		prefsColor.green = 123;
		prefsColor.blue = 113;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefsColorData, 
				prefsColorSize);
	}
	SetPreferredMyButtonGadgetViewColor(&prefsColor);
	BRect windowPrefArea;
	const void * windowPrefAreaData;
	size_t windowPrefAreaSize;
	uint32 windowPrefAreaType = '    ';
	if (	appsPreferenceSet.GetData(	"WordWrapMainFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
					22, 
					screenResolutionRect.right - 17,
					screenResolutionRect.bottom - 37);
					//the - 17 and - 37 were determined based upon trial and error
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredWordWrapWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"WordWrapPreferencesFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
					22, 
					screenResolutionRect.right - 17,
					screenResolutionRect.bottom - 37);
					//the - 17 and - 37 were determined based upon trial and error
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredPreferencesWindowRect(windowPrefArea);
}//end


MyApp	::	~MyApp() 
{
	bool allSetsOK = true;
	rgb_color tempRgbColor;
	GetPreferredColorWellGadgetHighColor(&tempRgbColor);
	if (appsPreferenceSet.SetData(	"PreferredColorWellGadgetHighColor", 
									&tempRgbColor, 
									sizeof(tempRgbColor), 
									B_RGB_COLOR_TYPE))
	{
		warning("Prefs cannot set PreferredColorWellGadgetHighColor.\n");
		allSetsOK = false;
	}
	else 
	{
		GetPreferredColorWellGadgetLowColor(&tempRgbColor);	
		if (appsPreferenceSet.SetData("PreferredColorWellGadgetLowColor", &tempRgbColor, sizeof(tempRgbColor), B_RGB_COLOR_TYPE))
		{
			warning("Prefs cannot set PreferredColorWellGadgetLowColor.\n");
			allSetsOK = false;
		}
		else 
		{
			GetPreferredColorWellGadgetViewColor(&tempRgbColor);
			if (appsPreferenceSet.SetData("PreferredColorWellGadgetViewColor", &tempRgbColor, sizeof(tempRgbColor), B_RGB_COLOR_TYPE))
			{
				warning("Prefs cannot set PreferredColorWellGadgetViewColor.\n");
				allSetsOK = false;
			}
			else
			{
				GetPreferredIntGadgetHighColor(&tempRgbColor);
				if (appsPreferenceSet.SetData(	"PreferredIntGadgetHighColor", 
												&tempRgbColor, 
												sizeof(tempRgbColor), 
												B_RGB_COLOR_TYPE))
				{
					warning("Prefs cannot set PreferredIntGadgetHighColor.\n");
					allSetsOK = false;
				}
				else 
				{
					GetPreferredMyButtonGadgetHighColor(&tempRgbColor);
					if (appsPreferenceSet.SetData(	"PreferredMyButtonGadgetHighColor", 
													&tempRgbColor, 
													sizeof(tempRgbColor), 
													B_RGB_COLOR_TYPE))
					{
						warning("Prefs cannot set PreferredMyButtonGadgetHighColor.\n");
						allSetsOK = false;
					}
					else 
					{
						GetPreferredMyButtonGadgetLowColor(&tempRgbColor);	
						if (appsPreferenceSet.SetData("PreferredMyButtonGadgetLowColor", &tempRgbColor, sizeof(tempRgbColor), B_RGB_COLOR_TYPE))
						{
							warning("Prefs cannot set PreferredMyButtonGadgetLowColor.\n");
							allSetsOK = false;
						}
						else 
						{
							GetPreferredMyButtonGadgetViewColor(&tempRgbColor);
							if (appsPreferenceSet.SetData("PreferredMyButtonGadgetViewColor", &tempRgbColor, sizeof(tempRgbColor), B_RGB_COLOR_TYPE))
							{
								warning("Prefs cannot set PreferredMyButtonGadgetViewColor.\n");
								allSetsOK = false;
							}
							else
							{
								GetPreferredIntGadgetLowColor(&tempRgbColor);	
								if (appsPreferenceSet.SetData("PreferredIntGadgetLowColor", &tempRgbColor, sizeof(tempRgbColor), B_RGB_COLOR_TYPE))
								{
									warning("Prefs cannot set PreferredIntGadgetLowColor.\n");
									allSetsOK = false;
								}
								else 
								{
									GetPreferredIntGadgetViewColor(&tempRgbColor);
									if (appsPreferenceSet.SetData("PreferredIntGadgetViewColor", &tempRgbColor, sizeof(tempRgbColor), B_RGB_COLOR_TYPE))
									{
										warning("Prefs cannot set PreferredIntGadgetViewColor.\n");
										allSetsOK = false;
									}
									else
									{
										GetPreferredHighColor(&tempRgbColor);
										if (appsPreferenceSet.SetData(	"PreferredHighColor", 
																		&tempRgbColor, 
																		sizeof(tempRgbColor), 
																		B_RGB_COLOR_TYPE))
										{
											warning("Prefs cannot set PreferredHighColor.\n");
											allSetsOK = false;
										}
										else 
										{
											GetPreferredLowColor(&tempRgbColor);	
											if (appsPreferenceSet.SetData("PreferredLowColor", &tempRgbColor, sizeof(tempRgbColor), B_RGB_COLOR_TYPE))
											{
												warning("Prefs cannot set PreferredLowColor.\n");
												allSetsOK = false;
											}
											else 
											{
												GetPreferredViewColor(&tempRgbColor);
												if (appsPreferenceSet.SetData("PreferredViewColor", &tempRgbColor, sizeof(tempRgbColor), B_RGB_COLOR_TYPE))
												{
													warning("Prefs cannot set PreferredViewColor.\n");
													allSetsOK = false;
												}
												else
												{
													FontData windowFontData(GetPreferredFont());
													if (((MyApp *)be_app)->appsPreferenceSet.SetData(	"FONTDATAPREFERENCE_TYPE", 
																										&windowFontData, 
																										sizeof(windowFontData), 
																										FONTDATAPREFERENCE_TYPE))
													{
														warning("Prefs cannot set FONTDATAPREFERENCE_TYPE.\n");
														allSetsOK = false;
													}
													else
													{
														uint32 wrapAt = ((MyApp *)be_app)->GetPreferredWrapAt();
														if (((MyApp *)be_app)->appsPreferenceSet.SetData(	"preferredWrapAt", 
																											&wrapAt, 
																											((MyApp *)be_app)->SizeOfPreferredWrapAt(), 
																											B_UINT32_TYPE))
														{
															warning("Prefs cannot set preferredWrapAt.\n");
															allSetsOK = false;
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (allSetsOK)
	{
		if (appsPreferenceSet.Save())
		{
			warning("Prefs cannot save settings.\n");
		}
	}
	delete preferredFont;
}//end


//all apps will need a main window to display on launch
void 
MyApp	::	ReadyToRun(				void) 
{
	try 
	{
		BRect holdRect;
		GetPreferredWordWrapWindowRect(&holdRect);
		auto_ptr<MainWindow> apMainWindow(new MainWindow(	holdRect,
															"Word Wrap by Ed Musgrove #2076",
															"mainScrollView",
															"WordWrapMainFrame"));
		pMainWindow = apMainWindow.get();
		apMainWindow.release();
		pMainWindow->Initialize();
	}
	catch (...) 
	{
		warning("No new ScrollingWordWrapWindow\n");
		be_app->PostMessage(new BMessage(B_QUIT_REQUESTED));
	}
}//end


void 
MyApp	::	MessageReceived(		BMessage *	message) 
{
	switch(message->what)
	{
		case REOPEN:
		{
			try 
			{
				BRect holdRect;
				GetPreferredWordWrapWindowRect(&holdRect);
				auto_ptr<MainWindow> apMainWindow(new MainWindow(	holdRect,
																	"Word Wrap by Ed Musgrove #2076",
																	"mainScrollView",
																	"WordWrapMainFrame"));
				pMainWindow = apMainWindow.get();
				apMainWindow.release();
				pMainWindow->Initialize();
			}
			catch (...)
			{
				warning("No renewed ScrollingWordWrapWindow\n");
				be_app->PostMessage(new BMessage(B_QUIT_REQUESTED));
			}
		break;
		}
		default:
			//I don't expect any msgs here
			warning("Unexpected BeApp message received.\n");
			BApplication::MessageReceived(message);
		break;
	}
}//end


BFont *	
MyApp	::	GetPreferredFont(		void) const
{
	return preferredFont;
}//end


void
MyApp	::	SetPreferredFont(		const BFont * pparamFont)
{
	*preferredFont = *pparamFont;
}//end


void
MyApp	::	SetToPreferredFont(		BFont * pparamFont)
{
	pparamFont->SetFamilyAndStyle(	preferredFont->FamilyAndStyle());
	pparamFont->SetSize(	preferredFont->Size());
	pparamFont->SetShear(	preferredFont->Shear());
	pparamFont->SetRotation(	preferredFont->Rotation());
	pparamFont->SetSpacing(	preferredFont->Spacing());
	pparamFont->SetEncoding(	preferredFont->Encoding());
	pparamFont->SetFace(	preferredFont->Face());
	pparamFont->SetFlags(	preferredFont->Flags());
	//?? pparamFont->Direction = preferredFont->Direction;
}//end


void
MyApp	::	SetPreferredFontFromData(	FontData * pparamFontData)
{
	preferredFont->SetFamilyAndStyle(pparamFontData->familyAndStyle);
	preferredFont->SetSize(pparamFontData->size);
	preferredFont->SetShear(pparamFontData->shear);
	preferredFont->SetRotation(pparamFontData->rotation);
	preferredFont->SetSpacing(pparamFontData->spacing);
	preferredFont->SetFace(pparamFontData->face);
	preferredFont->SetFlags(pparamFontData->flags);
}//end


void
MyApp	::	GetPreferredWordWrapWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredWordWrapWindowRect;
}//end


void
MyApp	::	SetPreferredWordWrapWindowRect(	const BRect paramWindowRect)
{
	preferredWordWrapWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredPreferencesWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredPreferencesWindowRect;
}//end


void
MyApp	::	SetPreferredPreferencesWindowRect(	const BRect paramWindowRect)
{
	preferredPreferencesWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredHighColor.red;
	pparamRGBColor->green = preferredHighColor.green;
	pparamRGBColor->blue = preferredHighColor.blue;
	pparamRGBColor->alpha = preferredHighColor.alpha;
}//end


void
MyApp	::	SetPreferredHighColor(	const rgb_color * pparamRGBColor)
{
	preferredHighColor.red = pparamRGBColor->red;
	preferredHighColor.green = pparamRGBColor->green;
	preferredHighColor.blue = pparamRGBColor->blue;
	preferredHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyApp	::	GetPreferredLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredLowColor.red;
	pparamRGBColor->green = preferredLowColor.green;
	pparamRGBColor->blue = preferredLowColor.blue;
	pparamRGBColor->alpha = preferredLowColor.alpha;
}//end


void
MyApp	::	SetPreferredLowColor(	const rgb_color * pparamRGBColor)
{
	preferredLowColor.red = pparamRGBColor->red;
	preferredLowColor.green = pparamRGBColor->green;
	preferredLowColor.blue = pparamRGBColor->blue;
	preferredLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyApp	::	GetPreferredViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredViewColor.red;
	pparamRGBColor->green = preferredViewColor.green;
	pparamRGBColor->blue = preferredViewColor.blue;
	pparamRGBColor->alpha = preferredViewColor.alpha;
}//end


void
MyApp	::	SetPreferredViewColor(	const rgb_color * pparamRGBColor)
{
	preferredViewColor.red = pparamRGBColor->red;
	preferredViewColor.green = pparamRGBColor->green;
	preferredViewColor.blue = pparamRGBColor->blue;
	preferredViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyApp	::	GetPreferredIntGadgetHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredIntGadgetHighColor.red;
	pparamRGBColor->green = preferredIntGadgetHighColor.green;
	pparamRGBColor->blue = preferredIntGadgetHighColor.blue;
	pparamRGBColor->alpha = preferredIntGadgetHighColor.alpha;
}//end


void
MyApp	::	SetPreferredIntGadgetHighColor(	const rgb_color * pparamRGBColor)
{
	preferredIntGadgetHighColor.red = pparamRGBColor->red;
	preferredIntGadgetHighColor.green = pparamRGBColor->green;
	preferredIntGadgetHighColor.blue = pparamRGBColor->blue;
	preferredIntGadgetHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyApp	::	GetPreferredIntGadgetLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredIntGadgetLowColor.red;
	pparamRGBColor->green = preferredIntGadgetLowColor.green;
	pparamRGBColor->blue = preferredIntGadgetLowColor.blue;
	pparamRGBColor->alpha = preferredIntGadgetLowColor.alpha;
}//end


void
MyApp	::	SetPreferredIntGadgetLowColor(	const rgb_color * pparamRGBColor)
{
	preferredIntGadgetLowColor.red = pparamRGBColor->red;
	preferredIntGadgetLowColor.green = pparamRGBColor->green;
	preferredIntGadgetLowColor.blue = pparamRGBColor->blue;
	preferredIntGadgetLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyApp	::	GetPreferredIntGadgetViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredIntGadgetViewColor.red;
	pparamRGBColor->green = preferredIntGadgetViewColor.green;
	pparamRGBColor->blue = preferredIntGadgetViewColor.blue;
	pparamRGBColor->alpha = preferredIntGadgetViewColor.alpha;
}//end


void
MyApp	::	SetPreferredIntGadgetViewColor(	const rgb_color * pparamRGBColor)
{
	preferredIntGadgetViewColor.red = pparamRGBColor->red;
	preferredIntGadgetViewColor.green = pparamRGBColor->green;
	preferredIntGadgetViewColor.blue = pparamRGBColor->blue;
	preferredIntGadgetViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyApp	::	GetPreferredColorWellGadgetHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredColorWellGadgetHighColor.red;
	pparamRGBColor->green = preferredColorWellGadgetHighColor.green;
	pparamRGBColor->blue = preferredColorWellGadgetHighColor.blue;
	pparamRGBColor->alpha = preferredColorWellGadgetHighColor.alpha;
}//end


void
MyApp	::	SetPreferredColorWellGadgetHighColor(	const rgb_color * pparamRGBColor)
{
	preferredColorWellGadgetHighColor.red = pparamRGBColor->red;
	preferredColorWellGadgetHighColor.green = pparamRGBColor->green;
	preferredColorWellGadgetHighColor.blue = pparamRGBColor->blue;
	preferredColorWellGadgetHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyApp	::	GetPreferredColorWellGadgetLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredColorWellGadgetLowColor.red;
	pparamRGBColor->green = preferredColorWellGadgetLowColor.green;
	pparamRGBColor->blue = preferredColorWellGadgetLowColor.blue;
	pparamRGBColor->alpha = preferredColorWellGadgetLowColor.alpha;
}//end


void
MyApp	::	SetPreferredColorWellGadgetLowColor(	const rgb_color * pparamRGBColor)
{
	preferredColorWellGadgetLowColor.red = pparamRGBColor->red;
	preferredColorWellGadgetLowColor.green = pparamRGBColor->green;
	preferredColorWellGadgetLowColor.blue = pparamRGBColor->blue;
	preferredColorWellGadgetLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyApp	::	GetPreferredColorWellGadgetViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredColorWellGadgetViewColor.red;
	pparamRGBColor->green = preferredColorWellGadgetViewColor.green;
	pparamRGBColor->blue = preferredColorWellGadgetViewColor.blue;
	pparamRGBColor->alpha = preferredColorWellGadgetViewColor.alpha;
}//end


void
MyApp	::	SetPreferredColorWellGadgetViewColor(	const rgb_color * pparamRGBColor)
{
	preferredColorWellGadgetViewColor.red = pparamRGBColor->red;
	preferredColorWellGadgetViewColor.green = pparamRGBColor->green;
	preferredColorWellGadgetViewColor.blue = pparamRGBColor->blue;
	preferredColorWellGadgetViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyApp	::	GetPreferredMyButtonGadgetHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyButtonGadgetHighColor.red;
	pparamRGBColor->green = preferredMyButtonGadgetHighColor.green;
	pparamRGBColor->blue = preferredMyButtonGadgetHighColor.blue;
	pparamRGBColor->alpha = preferredMyButtonGadgetHighColor.alpha;
}//end


void
MyApp	::	SetPreferredMyButtonGadgetHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyButtonGadgetHighColor.red = pparamRGBColor->red;
	preferredMyButtonGadgetHighColor.green = pparamRGBColor->green;
	preferredMyButtonGadgetHighColor.blue = pparamRGBColor->blue;
	preferredMyButtonGadgetHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyApp	::	GetPreferredMyButtonGadgetLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyButtonGadgetLowColor.red;
	pparamRGBColor->green = preferredMyButtonGadgetLowColor.green;
	pparamRGBColor->blue = preferredMyButtonGadgetLowColor.blue;
	pparamRGBColor->alpha = preferredMyButtonGadgetLowColor.alpha;
}//end


void
MyApp	::	SetPreferredMyButtonGadgetLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyButtonGadgetLowColor.red = pparamRGBColor->red;
	preferredMyButtonGadgetLowColor.green = pparamRGBColor->green;
	preferredMyButtonGadgetLowColor.blue = pparamRGBColor->blue;
	preferredMyButtonGadgetLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyApp	::	GetPreferredMyButtonGadgetViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyButtonGadgetViewColor.red;
	pparamRGBColor->green = preferredMyButtonGadgetViewColor.green;
	pparamRGBColor->blue = preferredMyButtonGadgetViewColor.blue;
	pparamRGBColor->alpha = preferredMyButtonGadgetViewColor.alpha;
}//end


void
MyApp	::	SetPreferredMyButtonGadgetViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyButtonGadgetViewColor.red = pparamRGBColor->red;
	preferredMyButtonGadgetViewColor.green = pparamRGBColor->green;
	preferredMyButtonGadgetViewColor.blue = pparamRGBColor->blue;
	preferredMyButtonGadgetViewColor.alpha = pparamRGBColor->alpha;
}//end


uint32 
MyApp	::  GetPreferredWrapAt(	void)
{
	return preferredWrapAt;
}//end


void
MyApp	::  SetPreferredWrapAt(	uint32	ui32paramSetTo)
{
	preferredWrapAt = ui32paramSetTo;
}//end


size_t
MyApp	::  SizeOfPreferredWrapAt(	void) const
{
	return sizeof(preferredWrapAt);
}//end


void
MyApp	::  OpenPreferencesPanel(	void)
{
	if (pPrefWindow)
	{
		pPrefWindow->Activate(true);
	}
	else
	{
		try 
		{
			BRect holdRect;
			GetPreferredPreferencesWindowRect(&holdRect);
			auto_ptr<PrefWindow> apPrefWindow(new PrefWindow(	holdRect,
																"WordWrap Preferences",
																"WordWrap Preferences scroll view",
																"WordWrapPreferencesFrame"));
			pPrefWindow = apPrefWindow.get();
			apPrefWindow.release();
			pPrefWindow->Initialize();
		}
		catch (...) 
		{
			warning("No new preference window.\n");
			return;
		}
	}
}//end