/****************************************************************************
** 	cryptic.cpp
**
**	Copyright (C) 2000, Jason Parks <atreyu@acm.org>.  All rights reserved.
**
*****************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include <Box.h>
#include <MenuField.h>
#include <MenuItem.h>
#include <Message.h>
#include <PopUpMenu.h>
#include <StorageKit.h>
#include <String.h>
#include <TrackerAddon.h>
#include <TranslatorRoster.h>
#include <View.h>
#include <Window.h>

#include <getopt.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

const uint32 BLOWFISH_ENCRYPT 	= 'blow';
const uint32 BLOWFISH_DECRYPT 	= 'fish';
const int32 MAX_USER_KEY_LENGTH = 448 / 8;

const int32 BLOWFISH	= 'bfsh';
const int32 ENCRYPT		= 'encr';
const int32 DECRYPT		= 'decr';

void Usage(int argc, char *argv[]) 
{
	printf("Usage: %s --encrypt --decrypt --key key\n"
	       "\tfile [--help]\n"
	       , argv[0]);
	exit(0);
}

int main(int argc, char *argv[])
{
	int decrypt = false;
	int encrypt = false;
	char *key =  (char *)malloc(MAX_USER_KEY_LENGTH);
	int c;
	
	if(argc != 5)
	{
		Usage(argc, argv);
		exit(0);
	}
	
	int option_index = 0;
	static struct option long_options[] = 
	{
		{"decrypt", 0, &decrypt, true},
		{"encrypt", 0, &encrypt, true},
		{"key", 1, 0, 'k'},
		{"help", 0, 0, 'h'}, 
		{0,0,0,0}
	};
	
	//get the command arguments
	while((c = getopt_long (argc, argv, "", long_options, &option_index)) != -1)
	{
		switch(c) 
		{
			case 'k':
			{
				strncpy(key, optarg, MAX_USER_KEY_LENGTH);
				break;
			}
			case 'h':
			{
				Usage(argc, argv);
				exit(0);
				break;
			}
			default:
			{	
				break;
			}
		}		
	}
	
	BFile inFile;
	BFile outFile;	
	
	char *path 	= (char *)malloc(B_FILE_NAME_LENGTH);
	
	status_t status1;
	status_t status2;
	
	strcpy(path, argv[argc - 1]);
	
	status1 = inFile.SetTo(path, B_READ_ONLY);
	status2 = outFile.SetTo(path, B_READ_WRITE);
	
	if(status1 != B_OK || status2 != B_OK)
	{
		printf("Input file not found.\n");
		exit(0);
	}
	
	//create the default list of translators
	BTranslatorRoster *roster = BTranslatorRoster::Default();
	
	//This BMessage is used to send the BLOWFISHTranslator the key.
	//This BMessage can contain any value for its commnad constant. 
	BMessage *ioExtension = new BMessage(B_ENTER);
	ioExtension->AddString("key", key);
	
	//decrypt or encrypt the file
	if(decrypt)
	{
		roster->Translate(&inFile, NULL, ioExtension, &outFile, BLOWFISH_DECRYPT);	
	}
	else
	{
		roster->Translate(&inFile, NULL, ioExtension, &outFile, BLOWFISH_ENCRYPT);	
	}
}