/* --------------------------------------------------------------------*/
/*                                                                     */
/*                            SysColors                                */
/*                                                                     */
/*                    Shows the 256 system colors                      */
/*                                                                     */
/* --------------------------------------------------------------------*/


#include <Application.h>
#include <Window.h>
#include <Box.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include <Rect.h>


/* --------------------------------------------------------------------*/
/*                            Definitions                              */
/* --------------------------------------------------------------------*/

// size of single color box

#define size 25


// ---------------------- Menu ---------------------------------

class tMyMenu : public BMenuBar
{ 
   public:  tMyMenu (BRect frame, const char *name);
};


// ---------------------- ColorShower ---------------------------------

class tShower : public BBox
{ 
   public:
     				tShower (BRect frame);
     virtual void 	Draw(BRect updateRect); 		 // override
};


// ---------------------- Main window ------------------------

class tMainWindow : public BWindow 
{
  public:
    				tMainWindow	(BRect frame);		// constructor
    virtual bool	QuitRequested();				// override
};

// ---------------------- ColorsApp ---------------------------

class tColorsApp : public BApplication
{
  public :  tColorsApp();							// constructor
};


/* --------------------------------------------------------------------*/
/*                        implementation                               */
/* --------------------------------------------------------------------*/


// ---------------------- MyMenu ------------------------

tMyMenu :: tMyMenu(BRect frame, const char *name) : BMenuBar(frame,name)
{   
  BMenu *SubMenu;
  AddItem (SubMenu = new BMenu ("File"));
  SubMenu->AddItem (new BMenuItem("Quit",new BMessage (B_QUIT_REQUESTED),'Q'));
};

  
// ----------------------- ColorShower -----------------------------

tShower :: tShower (BRect frame) : BBox(frame,"",B_FOLLOW_NONE,B_WILL_DRAW|B_FRAME_EVENTS,B_NO_BORDER) 
{
};  
  
void tShower :: Draw(BRect updateRect) // override
{
  int i,j;
  BRect R;
  for (j=0; j<16; j++) {
    for (i=0; i<16; i++) {
      R.Set (i*size,j*size,(i+1)*size-1,(j+1)*size-1);
      SetHighColor (system_colors()->color_list[j*16+i]);
      FillRect (R);
    };
  }    
};

// ---------------------- Main window ------------------------

tMainWindow:: tMainWindow (BRect frame) : BWindow(frame, "System colors", B_TITLED_WINDOW_LOOK, B_NORMAL_WINDOW_FEEL, B_NOT_RESIZABLE)
{
    Lock();
	BRect R = Bounds();
	tMyMenu *TheMenu = new tMyMenu(R,NULL);   	// constructs and adds menu
	AddChild (TheMenu);   

	ResizeBy (0,TheMenu->Frame().Height()+1);   // resizes window to add menu height

	R = Bounds();
	R.top = TheMenu->Frame().bottom+1;			// dimensions box size

	AddChild (new tShower(R));					// creates and adds shower
    Unlock();
};

bool tMainWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
};


// ---------------------- Colors App ------------------------

tColorsApp::tColorsApp() : BApplication("application/x-vnd.Be-SysColors")
{
	tMainWindow *aWindow = new tMainWindow(BRect(0, 0, size*16-1, size*16-1));
	aWindow->MoveTo (100,100);
	aWindow->Show();
};

// ---------------- main program ------------------------

main()
{ 
   new tColorsApp();
   be_app->Run();
   delete be_app;
}

