#include <Alert.h>
#include <Directory.h>
#include <Entry.h>
#include <Message.h>
#include <Node.h>
#include <Roster.h>
#include <TypeConstants.h>
#include <be_apps/NetPositive/NetPositive.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


#define BUFFER_SIZE        256
#define NUMBER_OF_COLUMNS  2


void print_usage(int argc, char *argv[]) {
   printf("USAGE: %s [-html]\n", argv[0]);
   exit(1);
}


int main(int argc, char *argv[])
{
   // Figure out if the application was started from the command-line
   // or via a double-click.  There are better ways to determine this,
   // but this method will work in all but a few cases.
   bool atty = isatty(fileno(stdin));

   FILE *outfile = stdout;
   bool print_html = false;

   // The application was started from the command-line.
   if (atty) {
      if ((argc != 1) && (argc != 2)) {
	 print_usage(argc, argv);
      } else if (argc == 2) {
	 if (strcmp(argv[1], "-html") == 0) {
	    print_html = true;
	 } else {
	    print_usage(argc, argv);
	 }
      }
   } 
   // The application was started via a double-click.
   else {
      outfile = fopen("/boot/home/people/show_people.html", "w");

      if (!outfile) {
	 system ("/bin/alert "
		 "\"Unable to create the file \\\"/boot/home/people/show_people.html\\\".\" "
		 "OK");
	 exit(1);
      }
      
      print_html = true;
   }

   BDirectory people_dir("/boot/home/people");
   BEntry person_entry;
   BNode person_node;

   // Count the number of people in the people directory so that we
   // can make the HTML table columns approximately the same length.
   int num_people = 0;

   people_dir.Rewind();
   while (people_dir.GetNextEntry(&person_entry) == B_OK) {
      num_people++;
   }   

   if (print_html) {
      fprintf(outfile, "<html>\n");
      fprintf(outfile, "<head>\n<title>BeOS People Entries</title>\n</head>\n");
      fprintf(outfile, "<body>\n<center>\n");
      fprintf(outfile, "<table border=1 cellpadding=10>\n");
   }

   // Keep track of how many people we've processed so we'll know when
   // to start each new column in the table.
   int current_person = 0;

   people_dir.Rewind();
   while (people_dir.GetNextEntry(&person_entry) == B_OK) {
      person_node.SetTo(&person_entry);

      char buffer[BUFFER_SIZE];

      if (person_node.ReadAttr("META:name", B_STRING_TYPE, 0, buffer, BUFFER_SIZE) > 1) {
	 if (print_html) {
	    if ((current_person % NUMBER_OF_COLUMNS) == 0) {
	       fprintf(outfile, "<tr><td valign=top>\n");
	    } else {
	       fprintf(outfile, "<td valign=top>\n");
	    }

	    fprintf(outfile, "<p><center><b>%s</b>\n</center><ul>\n", buffer);
	 } else {
	    fprintf(outfile, "%s\n", buffer);
	 }
      } else {
	 continue;
      }

      if (person_node.ReadAttr("META:email", B_STRING_TYPE, 0, buffer, BUFFER_SIZE) > 1) {
	 if (print_html) {
	    fprintf(outfile, "<dt><a href=\"mailto:%s\">%s</a>\n", buffer, buffer);
	 } else {
	    fprintf(outfile, "%s\n", buffer);
	 }
      } else if (print_html) {
	 fprintf(outfile, "<dt>&nbsp\n", buffer);
      }

      if (person_node.ReadAttr("META:hphone", B_STRING_TYPE, 0, buffer, BUFFER_SIZE) > 1) {
	 if (print_html) {
	    fprintf(outfile, "<dt>%s\n", buffer);
	 } else {
	    fprintf(outfile, "%s\n", buffer);
	 }
      } else if (print_html) {
	 fprintf(outfile, "<dt>&nbsp\n", buffer);
      }

      if (person_node.ReadAttr("META:address", B_STRING_TYPE, 0, buffer, BUFFER_SIZE) > 1) {
	 if (print_html) {
	    fprintf(outfile, "<dt>%s\n", buffer);
	 } else {
	    fprintf(outfile, "%s\n", buffer);
	 }

	 person_node.ReadAttr("META:city", B_STRING_TYPE, 0, buffer, BUFFER_SIZE);
	 if (print_html) {
	    fprintf(outfile, "<br>%s, ", buffer);
	 } else {
	    fprintf(outfile, "%s, ", buffer);
	 }

	 person_node.ReadAttr("META:state", B_STRING_TYPE, 0, buffer, BUFFER_SIZE);
	 if (print_html) {
	    fprintf(outfile, "%s ", buffer);
	 } else {
	    fprintf(outfile, "%s ", buffer);
	 }

	 person_node.ReadAttr("META:zip", B_STRING_TYPE, 0, buffer, BUFFER_SIZE);      
	 if (print_html) {
	    fprintf(outfile, "%s\n", buffer);
	 } else {
	    fprintf(outfile, "%s\n", buffer);
	 }
      } else if (print_html) {
	 fprintf(outfile, "<dt>&nbsp\n<br>&nbsp\n", buffer);
      }

      if (print_html) {
	 fprintf(outfile, "</ul>\n");
      } else {
	 fprintf(outfile, "\n");
      }

      person_node.Unset();
      current_person++;
   }

   if (print_html) {
      fprintf(outfile, "</table>\n</center>\n</body>\n</html>\n");
   }

   // We will only try to open NetPositive if the application was
   // started via a double-click.
   if (!atty) {
      fclose (outfile);

#if 0
      // Create a message to send to NetPositive.  If the user
      // normally views HTML files with another application, then
      // tough!
      BMessage msg(B_NETPOSITIVE_OPEN_URL);
      msg.AddString("be:url", "file:///boot/home/people/show_people.html");

      // If NetPositive is already running we will send the open URL
      // message to the existing team.  Otherwise, we will launch
      // NetPositive and send it the message.
      BRoster roster;

      team_id netpos = roster.TeamFor(B_NETPOSITIVE_APP_SIGNATURE);

      if (netpos) {
	 roster.Launch(B_NETPOSITIVE_APP_SIGNATURE, &msg, &netpos);
      } else {
	 roster.Launch(B_NETPOSITIVE_APP_SIGNATURE, &msg);
      }
#else
      // This will open the show_people.html file with the application
      // which the user has designated to handle HTML files.
      system("/boot/beos/system/Tracker /boot/home/people/show_people.html");
#endif
   }

   return B_OK;
}
