/* ArpPrefsI.h
 * Copyright (c)2000 by Eric Hackborn.
 * All rights reserved.
 *
 * This file defines classes that provide global, application-wide
 * behaviour, along with functions for accessing instances of each
 * of these classes.  The application implementing this library needs
 * to implement the accessing functions.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Eric Hackborn,
 * at <hackborn@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * To Do
 * ~~~~~~~~~~
 *
 *	- Nothing!
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 *	- None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * 05.08.00		hackborn
 * Created this file.
 */

#ifndef AMPUBLIC_AMPREFSI_H
#define AMPUBLIC_AMPREFSI_H

#include "ArpViewsPublic/ArpPrefsI.h"
// Here is where the colour constants are defined.
#include "AmPublic/AmDefs.h"

/***************************************************************************
 * AM-PREFERENCES-I
 * An interface required by some of the AmKernel view classes.
 ***************************************************************************/
// Forward reference
class AmPreferencesI;
// Accessing function
AmPreferencesI& AmPrefs();
// Let application attach preferences object
void SetAmPrefs(AmPreferencesI& prefs);

class AmPreferencesI : public ArpPreferencesI
{
public:
	virtual ~AmPreferencesI()	{ }
	
	/* Answer a color somewhere between AM_LOW_PRIMARY_EVENT_C and
	 * AM_HIGH_PRIMARY_EVENT_C, depending on the value of velocity.
	 * A velocity of 0 is the low colour, 127 is the high colour.
	 */
	virtual rgb_color	PrimaryColor(uint8 velocity = 127) const = 0;
	/* Answer a color somewhere between AM_LOW_SECONDARY_EVENT_C and
	 * AM_HIGH_SECONDARY_EVENT_C, depending on the value of velocity.
	 * A velocity of 0 is the low colour, 127 is the high colour.
	 */
	virtual rgb_color	SecondaryColor(uint8 velocity = 127) const = 0;
	/* Answer a color somewhere between AM_LOW_SELECTED_EVENT_C and
	 * AM_HIGH_SELECTED_EVENT_C, depending on the value of velocity.
	 * A velocity of 0 is the low colour, 127 is the high colour.
	 */
	virtual rgb_color	SelectedColor(uint8 velocity = 127) const = 0;
};

#endif
