/* AmInstrumentI.h
 * Copyright (c)1998 by Eric Hackborn.
 * All rights reserved.
 *
 * This class is the public means of accessing instrument definitions.
 * An instrument is one concrete piece of MIDI gear - a Korg Wavestation,
 * for example.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Eric Hackborn,
 * at <hackborn@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 *	• None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * 09.30.98		hackborn
 * Created this file
 */

#ifndef AMPUBLIC_AMINSTRUMENTI_H
#define AMPUBLIC_AMINSTRUMENTI_H

#include <be/support/SupportDefs.h>
#include <AmPublic/AmBankI.h>


class AmInstrumentI : public ArpRefableI {
	public:
		virtual ~AmInstrumentI() { }
		
		virtual ArpCRef<AmBankI> Bank(uint32 number) const = 0;
		virtual uint32 CountBanks() const = 0;
		
		virtual BString ControlName(ulong controlNumber) const = 0;
		virtual uint32 CountControls() const = 0;
		
		virtual BString Name() const = 0;
};


#endif /* ARP_MIDI_INSTRUMENT_H */
