#include "Mlm78.h"

class MXStringControl : public BControl
{
public:
	MXStringControl(BRect frame, const char *name, const char *label);
	virtual ~MXStringControl(void);
	virtual void Draw(BRect frame);
	virtual void AttachedToWindow(void);
	virtual void GetPreferredSize(float *width, float *height);
	virtual void SetValue(int32 value);
private:
	
};



class MTempSlider : public BSlider
{
public:
	MTempSlider(BRect frame, const char *label, int32 minValue, int32 maxValue);
	virtual	~MTempSlider(void);
	virtual char *UpdateText(void) const;
	virtual void DrawThumb(void);
	virtual void MouseDown(BPoint point);	
	virtual void AttachedToWindow(void);

private:
	char *fTmpTxt;
};


class MSensorWindow : public BWindow
{
public:
	MSensorWindow();
	virtual	~MSensorWindow();

	bool QuitRequested(void);

private:
	static 	int32 _Update(void *arg);
			void Update(void);

	bool fThreadRun;
	thread_id	fThread;
	MTempSlider *fMbTempSlider;
	MXStringControl	*fVcore;
	MXStringControl	*fV33;
	MXStringControl	*fVp5;
	MXStringControl	*fVm5;
	MXStringControl	*fVp12;
	MXStringControl	*fVm12;
	MXStringControl	*fChassisFan;
	MXStringControl	*fCPUFan;
	MXStringControl	*fPowerFan;
};


class MSensorApp : public BApplication
{
public:
	MSensorApp();
	virtual	~MSensorApp();

	void ReadyToRun(void);

private:
	MSensorWindow *fSensorWindow;
};




// MSensorApp

MSensorApp::MSensorApp(void)
	: BApplication("application/x-ma-sensor")
{
}

MSensorApp::~MSensorApp(void)
{
}

void MSensorApp::ReadyToRun(void)
{
	if (Mlm78().InitCheck() != B_OK)
	{
		(new BAlert("Error", "LM78 driver not present!", "Quit", NULL,  NULL, B_WIDTH_AS_USUAL, B_STOP_ALERT))->Go();
		PostMessage(B_QUIT_REQUESTED);
	}
	else
	{
		fSensorWindow = new MSensorWindow;
	}
}


// MSensorWindow

MSensorWindow::MSensorWindow()
	: BWindow(BRect(0,0,256,160), "LM78 Sensor", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE)
{
	BScreen screen;
	MoveTo(screen.Frame().LeftTop() + BPoint(50,50));

	BView *root = new BView(Bounds(), NULL, B_FOLLOW_ALL, B_WILL_DRAW);
	root->SetViewColor(220,220,220,255);
	AddChild(root);
	
	BRect frame(8,8,248,40);
	fMbTempSlider = new MTempSlider(frame, "Motherboard temperature :", 0, 100);
	root->AddChild(fMbTempSlider);
	
	int d=14;
	root->AddChild(fVcore	= new MXStringControl(BRect(  8,64+0*d, 100,0), NULL,			"Vcore (V):"));
	root->AddChild(fV33		= new MXStringControl(BRect(148,64+0*d, 148+100,0), NULL,		" +3.3 (V):"));
	root->AddChild(fVp5		= new MXStringControl(BRect(8,64+1*d, 100,0), NULL,				" +5.0 (V):"));
	root->AddChild(fVm5		= new MXStringControl(BRect(8,64+2*d, 100,0), NULL,				" -5.0 (V):"));
	root->AddChild(fVp12		= new MXStringControl(BRect(148,64+1*d, 148+100,0), NULL, 	"+12.0 (V):"));
	root->AddChild(fVm12		= new MXStringControl(BRect(148,64+2*d, 148+100,0), NULL, 	"-12.0 (V):"));
	root->AddChild(fChassisFan	= new MXStringControl(BRect(8,70+3*d, 200,0), NULL, "Chassi Fan (Rpm)      :"));
	root->AddChild(fCPUFan		= new MXStringControl(BRect(8,70+4*d, 200,0), NULL, "CPU Fan (Rpm)         :"));
	root->AddChild(fPowerFan	= new MXStringControl(BRect(8,70+5*d, 200,0), NULL, "Power supply Fan (Rpm):"));

	Show();

	fThread = spawn_thread(_Update, "SensorThread", B_LOW_PRIORITY, this);
	resume_thread(fThread);
}

MSensorWindow::~MSensorWindow()
{
	int32 dummy;
	fThreadRun = false;
	wait_for_thread(fThread, &dummy);
}

int32 MSensorWindow::_Update(void *arg)
{
	MSensorWindow *obj = (MSensorWindow *)arg; 
	obj->Update();
	return NULL;
}

void MSensorWindow::Update(void)
{
	fThreadRun = true;
	while (fThreadRun == true)
	{
		if (Lock())
		{
			Mlm78 sensor;
			if (sensor.InitCheck() == B_OK)
			{
				sensor();
				fVcore->SetValue		(sensor.VCore * 100.0);
				fV33->SetValue			(sensor.V33 * 100.0);
				fVp5->SetValue			(sensor.Vp5 * 100.0);
				fVm5->SetValue			(sensor.Vm5 * 100.0);
				fVp12->SetValue			(sensor.Vp12 * 100.0);
				fVm12->SetValue			(sensor.Vm12 * 100.0);
				fChassisFan->SetValue	(sensor.ChassisFan * 100.0);
				fCPUFan->SetValue		(sensor.CPUFan * 100.0);
				fPowerFan->SetValue		(sensor.PowerFan * 100.0);
				fMbTempSlider->SetValue	(sensor.MotherboardTemp);
			}
			Unlock();
		}

		for (int i=0 ; i<10 ; i++)
			snooze(100000.0);
	}
}


bool MSensorWindow::QuitRequested(void)
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

// MTempSlider
MTempSlider::MTempSlider(BRect frame, const char *label, int32 minValue, int32 maxValue)
	: BSlider(frame, NULL, label, NULL, minValue, maxValue, B_TRIANGLE_THUMB)
{
	SetHashMarks(B_HASH_MARKS_BOTTOM);
	SetHashMarkCount(11);
	SetLimitLabels("Ice", "Vapor");
	const rgb_color bar_color_mem = {152, 152, 255, 255};
	const rgb_color fil_color_mem = {255,  80,  80, 255};
	SetBarColor(bar_color_mem);
	UseFillColor(true, &fil_color_mem);
	fTmpTxt = new char[32];
}

MTempSlider::~MTempSlider(void)
{
	delete [] fTmpTxt;
}

void MTempSlider::AttachedToWindow(void)
{
	BSlider::AttachedToWindow();
	SetViewColor(Parent()->ViewColor());
}

char *MTempSlider::UpdateText(void) const
{
	sprintf(fTmpTxt, "%u°C", (unsigned int)Value());
	return fTmpTxt;
}

void MTempSlider::DrawThumb(void)
{
	BSlider::DrawThumb();
}

void MTempSlider::MouseDown(BPoint point)
{
}

// MXStringControl

MXStringControl::MXStringControl(BRect frame, const char *name, const char *label)
	: BControl(frame, name, label, NULL, B_FOLLOW_NONE, B_WILL_DRAW)
{
}

MXStringControl::~MXStringControl(void)
{
}

void MXStringControl::AttachedToWindow(void)
{
	BFont ourFont;
	ourFont.SetFamilyAndStyle("ProFontISOLatin1", "Regular");
	ourFont.SetSize(9.0);
	SetFont(&ourFont, B_FONT_ALL);
	SetViewColor(Parent()->ViewColor());
	SetHighColor(0,0,0,255);
	SetLowColor(ViewColor());
	ResizeToPreferred();
}

void MXStringControl::Draw(BRect frame)
{
	
	font_height h;
	GetFontHeight(&h);
	DrawString(Label(), BPoint(4.0, h.ascent));


	char tmp[32];
	if (Value() == 0)
	{
		sprintf(tmp, "n/a");
	}
	else
	{
		sprintf(tmp, "%6.1f", Value()/100.0);
	}
	MovePenTo(Bounds().Width()-StringWidth(tmp), h.ascent);
	DrawString(tmp);
}

void MXStringControl::GetPreferredSize(float *width, float *height)
{
	font_height h;
	GetFontHeight(&h);
	*width = Bounds().Width();
	*height = h.ascent + h.descent + h.leading;
}

void MXStringControl::SetValue(int32 value)
{
	if (value != Value())
	{
		BControl::SetValue(value);
		Invalidate();
	}
}

// main()

int main()
{
	new MSensorApp;
	be_app->Run();
	delete be_app;
	return NULL;
}
