//=====================================================================
// RfsvServer.h
// © Michael Pieper 14. Feb. 1999
//=====================================================================
//
//  This headerfile defines the class "RfsvServer", which is used to
//  manage the SYS$RFSV-Connection from the PSION
//
//=====================================================================

#ifndef RFSVSERVER_H
#define RFSVSERVER_H

#include "RfsvServerAddOn.h"
#include "debugMsg.h"
#include <SupportKit.h>			// needed for uint16 definition

#define RFSV_VERSION 2			// This program can manage the Version 2 of the RFSV

#define MAX_OPEN_FILES 16
#define OP_BPATH 1
#define OP_BFILE 2
#define OP_BVOL  3
#define OP_BDIR  4
#define MIN_SEND_BUFFER 7

typedef struct {
	bool					aktiv;	// it's true, when the entry is active
	int						fd;		// holds the filedescriptor sent from the PSION
	int						type;	// defines, what union-structure is used
	union {
		BPath				*bpath;		// BPath-Object for Path-Access
		BFile				*bfile;		// BFile-Object for File-Access
		BVolumeRoster		*bvolume;	// BVolumeRoster-Object for Device-Access
		BDirectory			*bdir;		// BDirectory-Object for Directory-Access
	}						pointer;	// union-name
} OPEN_HANDLER;

//=====================================================================
//  LinkServer class
class RfsvServer
{
public:
	//constructor and destructor
					RfsvServer( CONFIG_VAR *config );

private:
	// global variables need to communicate
	uint16			cid;							// Channelid to talk to the NCP
	port_id			pid_o, pid_i;					// Portids for the message handling
	DebugMsg		*dprint;						// Class for Debug-Messagees
	OPEN_HANDLER	open_files[MAX_OPEN_FILES];		// OpenHandler for infos on opened filehandles

	//operations
	void			RunServer( void );	// waits for a Message and manages this message
	
	int				rf_fopen( const char *name, int status );					// RF_OPEN
	int				rf_fclose( int fd );										// RF_CLOSE
	int				rf_fread( int fd, int anz, unsigned char *buffer );			// RF_FREAD
	int				rf_dirread( int fd, unsigned char * buffer, size_t len); 	// RF_DIRREAD
	int				rf_deviceread( int fd, unsigned char * buffer );			// RF_DEVICEREAD
	int				rf_write( int fd, int anz, const unsigned char *buffer );	// RF_WRITE
	int32			rf_fseek( int fd, long anz, int mode );						// RF_FSEEK
																				// RF_FLUSH
	int				rf_fseteof( int fd, long laenge );							// RF_FSETEOF
	int				rf_rename( const char *file_old, const char *file_new );	// RF_RENAME
	int				rf_delete( const char *filename );							// RF_DELETE
																				// RF_INFO
	int				rf_sfstat( const char *filename, int bit, int mask );		// RF_SFSTAT
	int				rf_mkdir( const char *dirname );							// RF_MKDIR
	int				rf_parse( char *file1, char *file2, char *file3, 
														unsigned char *werte );	// RF_PARSE
	int				rf_statusdevice( char *device, unsigned char *buffer );		// RF_STATUSDEVICE
																				// RF_PATHTEST
																				// RF_STATUSSYSTEM
	int				rf_changedir( int art, const char *start, 
										const char *zusatz, char *ergebnis );	// RF_CHANGEDIR
	int				rf_sfdate( const char *filename, long secs );				// RF_SFDATE
};

//=====================================================================

void WordToBytes(unsigned int i, unsigned char *p);
void LongToBytes(unsigned long l, unsigned char *p);
unsigned int BytesToWord(const unsigned char *c);
unsigned long BytesToLong(const unsigned char *c);

int copy_filesystem(const char *in, char *filesys);
int copy_device(const char *in, char *device);
int copy_path(const char *in, char *path);
int copy_filename(const char *in, char *filename);

int get_status(BEntry *bent, unsigned char *buffer);
void get_dev_stat(BVolume *bvol, unsigned char *buffer, char *dir);
char *find_filename(const char *filename);

#endif
