//============================================================================
// rfsvclient-addon.cpp
// © Michael Pieper 2. Apr. 1999
//   last modification: Michael Pieper 5.Apr.1999
//============================================================================
//
//	This addon exports the C-Function "RunClient", which is started, after
//  the NCP is running. It manages the filesystem mount and unmount function
//
//============================================================================

#include "RfsvClient.h"
#include "ConfigView.h"
#include "RfsvClientAddOn.h"

//============================================================================
// We have to public the Adresses, which are used from PalmBeach
//
extern "C" _EXPORT char InfoVersion[]="0.42  " B_UTF8_COPYRIGHT "1999 by Michael Pieper";
extern "C" _EXPORT char InfoLine1[]="RFSV = Remote File SerVice";
extern "C" _EXPORT char InfoLine2[]="used to connect the BeOS to the";
extern "C" _EXPORT char InfoLine3[]="PSION Filesystem";

extern "C" _EXPORT int32 RunClient( void );
extern "C" _EXPORT BView *ConfigView( BRect frame );
extern "C" _EXPORT int32 Initialise( void );

//============================================================================
// 

CONFIG_VAR	configs;							// here we reserve memory for the CONFIG_VAR

//============================================================================
// This Function is a Routine, which can initialize some global functions or variables

int32 Initialise( void ) {
	
	configs.debug = true;
	strcpy(configs.debugFile, "/var/log/rfsv-client.log");
	strcpy(configs.mountPoint, "/mnt/psion");
	return 0;
}

//============================================================================
// We have to start the LinkServer

int32 RunClient( void ) {

	RfsvClient	*rfsvClient;
	rfsvClient = new RfsvClient( &configs );	// generate a new RfsvClient and tell them the adress of the Config-Variables
	rfsvClient->StartMount();
	rfsvClient->WaitForShutdown();

	delete rfsvClient;

  	return 0;
}

//============================================================================
// We have to return a ConfigurationView. Every Message must be sent to
// the View itself, that we can do something with the Message!

BView *ConfigView( BRect frame )
{
	AddOnConfigView* configView;
  	configView = new AddOnConfigView( frame, &configs );	// generate a new RfsvClient and tell them the adress of the Config-Variables

  	return configView;
}
