//============================================================================
// LinkServerAddOn.cpp
// © Michael Pieper 14. Feb. 1999
//   last modification: Michael Pieper 5.Apr.1999
//============================================================================
//
//	This addon exports the C-Function "RunServer", which is started, when
//  the PSION asks for the "LINK"-Server
//
//============================================================================

#include "LinkServer.h"
#include "ConfigView.h"
#include "LinkServerAddOn.h"

//============================================================================

extern "C" _EXPORT char InfoVersion[]="0.11  " B_UTF8_COPYRIGHT "1999 by Michael Pieper";
extern "C" _EXPORT char InfoLine1[]="LINK = LINK Server";
extern "C" _EXPORT char InfoLine2[]="don't know why this is needed.";
extern "C" _EXPORT char InfoLine3[]="";

extern "C" _EXPORT int32 RunServer( void );
extern "C" _EXPORT BView *ConfigView( BRect frame );
extern "C" _EXPORT int32 Initialise( void );

//============================================================================
// 

CONFIG_VAR	configs;							// here we reserve memory for the CONFIG_VAR

//============================================================================
// This Function is a Routine, which can initialize some global functions or variables

int32 Initialise( void ) {
	
	configs.debug = true;
	strcpy(configs.debugFile, "/var/log/link-server.log");
	return 0;
}


//============================================================================
// We have to start the LinkServer

int32 RunServer( void )
{
	LinkServer* linkServer;
  	linkServer = new LinkServer( &configs );

	delete linkServer;				// When it returns, then clean up!
  	return 0;
}

//============================================================================
// We have to return a ConfigurationView. Every Message must be sent to
// the View itself, that we can do something with the Message!

BView *ConfigView( BRect frame )
{
	AddOnConfigView* configView;
  	configView = new AddOnConfigView( frame, &configs );

  	return configView;
}
