//=====================================================================
// ConfigView.h
// © Michael Pieper 28. Mar. 1999
//=====================================================================
//
//  This headerfile defines the class "AddOnConfigView", which is used to
//  manage the PalmBeach ADD-Ons-Configuration
//
//=====================================================================

#ifndef CONFIGVIEW_H
#define CONFIGVIEW_H

#include "LinkServerAddOn.h"
#include <InterfaceKit.h>

//=====================================================================
// We have to define the Internal Messages

#define ADDON_DEBUGBUTTON	'aodb'
#define ADDON_DEBUGFILESEL	'aofs'
#define ADDON_FILEPANEL		'aofp'

//=====================================================================
// AddOnConfigView Class


class AddOnConfigView : public BView
{
public:
					AddOnConfigView( BRect frame, CONFIG_VAR *conf ); 
					~AddOnConfigView( void );
					 
	void			ResizeToPreferred( void );
	void			GetPreferredSize( float *width, float *height );

private:
	void			AttachedToWindow( void );
	void			MessageReceived( BMessage *msg );

	BCheckBox		*debugCheckBox;
	BTextControl	*debugTextControl;
	BButton			*debugFileButton;
	BFilePanel		*saveFilePanel;
	
	float			prefWidth, prefHeight;
	
	CONFIG_VAR		*config;
};

#endif