//============================================================================
// SettingsView.cpp
// © Michael Pieper 27. Mar. 1999
//============================================================================
//
//	This class manages the preverences. 
//  It is possible to save and load the Pref's. You can set the
//  serial-port, the serial-speed and the mount-point
//============================================================================

#include "SettingsView.h"
#include "PsionNCP.h"
#include "PsiNCPWindow.h"
#include <InterfaceKit.h>		// We want to do some drawing :-)
#include <StorageKit.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//============================================================================
// Constructor for the View.
// We have to construct our design!
//

SettingsView::SettingsView(BRect rect, const char *name, BSerialPort *Port)
		: BView(rect, name, B_FOLLOW_ALL_SIDES, B_WILL_DRAW) 
		
{
	BRect 			r;
	BPopUpMenu		*pop;
	BMenuItem		*mi;
	char			buffer[B_FILE_NAME_LENGTH];
	font_height		fh;
	float			height;
	int32			dev_anz, l;
	
	PsiPort = Port;		// Set the private variable PsiPort!
	LoadPreferences();	// and load all the preferences, we saved!
	
	GetFontHeight(&fh);
	height = fh.ascent + fh.descent;
	SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));
	
	pop = new BPopUpMenu("select port");

	dev_anz = PsiPort->CountDevices();		// how much devices are installed in this COmputer?
	for (l = 0; l < dev_anz; l++) {			// walk through all of this
		PsiPort->GetDeviceName(l, buffer);	// ask them about his name
		pop->AddItem( new BMenuItem( buffer, new BMessage(MSG_PORT) ) ); 	// create a new Item
	}
	mi = pop->FindItem(PortName);			// find our saved setting
	if (mi != NULL) mi->SetMarked(true);	// and mark it

	r = Bounds();					// Setzen der Positionen!
	r.InsetBy(5,5);
	r.bottom = r.top + height + 5;
	
	serialDevice = new BMenuField(r, NULL, "Serial Device:", pop);
	serialDevice->SetAlignment( B_ALIGN_RIGHT );
	AddChild( serialDevice );
	
	pop = new BPopUpMenu("select speed");
	pop->AddItem ( mi = new BMenuItem("9600", new BMessage(MSG_B_9600_BPS) ) );
	if (DataRate == B_9600_BPS) mi->SetMarked(true);
	pop->AddItem ( mi = new BMenuItem("19200", new BMessage(MSG_B_19200_BPS) ) );
	if (DataRate == B_19200_BPS) mi->SetMarked(true);
	pop->AddItem ( mi = new BMenuItem("38400", new BMessage(MSG_B_38400_BPS) ) );
	if (DataRate == B_38400_BPS) mi->SetMarked(true);
	pop->AddItem ( mi = new BMenuItem("57600", new BMessage(MSG_B_57600_BPS) ) );
	if (DataRate == B_57600_BPS) mi->SetMarked(true);
	pop->AddItem ( mi = new BMenuItem("115200", new BMessage(MSG_B_115200_BPS) ) );
	if (DataRate == B_115200_BPS) mi->SetMarked(true);
	pop->AddItem ( mi = new BMenuItem("230400", new BMessage(MSG_B_230400_BPS) ) );
	if (DataRate == B_230400_BPS) mi->SetMarked(true);
	
	serialSpeed = new BMenuField(r, NULL, "Serial Speed:", pop);
	serialSpeed->MoveBy(0, r.Height()+5);
	serialSpeed->SetAlignment( B_ALIGN_RIGHT );
	AddChild( serialSpeed );

	r = serialSpeed->Frame();
	r.OffsetBy(r.Width()+5, 0);
	
	serialDevice->SetDivider( r.left );	// set all to the same left-Value
	serialSpeed->SetDivider( r.left );	// dito
	
	r = Frame();						// Den Save-Butten orientieren wir an den unteren Rand des Fensters
	saveButton = new BButton(r, "Save Preferences", "Save Preferences", 
						new BMessage(MSG_SAVE_PREF), B_FOLLOW_BOTTOM | B_FOLLOW_LEFT_RIGHT);
	saveButton->ResizeToPreferred();
	saveButton->MoveTo( (r.Width()-saveButton->Frame().Width())/2, r.bottom-(saveButton->Frame().Height()+5) );
	AddChild( saveButton );
	saveButton->SetEnabled(false);

}

//============================================================================
// The function AttachedToWindow sets the message for all elements in the view
// because we must be attached to select the View as the target!
//

void SettingsView::AttachedToWindow( void ) {

	serialDevice->Menu()->SetTargetForItems(this);	// every Item should send his BMessage to this view!
	serialSpeed->Menu()->SetTargetForItems(this);
	saveButton->SetTarget(this);			// only this view knows, what to do with the Messages
}

//===============================================================================
// We are interested in receiving some messages from this view. So we want to do 
// something with them
//

void SettingsView::MessageReceived( BMessage *msg ) {
	
	BMenuItem		*pmi;

	switch(msg->what) {
		case MSG_B_9600_BPS:	DataRate = B_9600_BPS;		break;
		case MSG_B_19200_BPS:	DataRate = B_19200_BPS;		break;
		case MSG_B_38400_BPS:	DataRate = B_38400_BPS;		break;
		case MSG_B_57600_BPS:	DataRate = B_57600_BPS;		break;
		case MSG_B_115200_BPS:	DataRate = B_115200_BPS;	break;
		case MSG_B_230400_BPS:	DataRate = B_230400_BPS;	break;
		case MSG_PORT:
			if (msg->FindPointer("source", (void **)&pmi) == B_OK)	// the source-Field contoins the Pointer to the BMenuItem
				strcpy(PortName, pmi->Label());				// Use the Label to remember it in PortName
			break;
		case MSG_SAVE_PREF:
			SavePreferences();	// Save all Preferences from "PalmBeach"
			break;
    }
	saveButton->SetEnabled(true);		// something happened, so we should allow the usre to save all!
}

//===============================================================================
// We have to save all Settings in a file.
//
void SettingsView::SavePreferences( void ) {

	BPath		path;
	BDirectory	*dir;
	BFile		*readFile, *writeFile;
	off_t		size;
	char		line[128], *mem, *c;
	
	find_directory(B_USER_SETTINGS_DIRECTORY, &path);		// Find the Settings-directory
	dir = new BDirectory(path.Path());						// set a Directory

	readFile = new BFile(dir, SETTING_FILE, B_READ_ONLY);
	writeFile = new BFile(dir, SETTING_BACKUP, B_READ_WRITE | B_CREATE_FILE | B_ERASE_FILE);
	
	if (writeFile->InitCheck() != B_OK) {
		// error! can't write file
		return;
	}
	c = NULL;
	
	if (readFile->InitCheck() == B_OK) {
		readFile->GetSize(&size);
		if (( mem = (char *)malloc( size )) != NULL) {
			readFile->Read(mem, size);
			c = strstr(mem, "[PalmBeach]\n");
			if (c != NULL ) {
				writeFile->Write(mem, (off_t )(c - mem));	// lets save all things before [PalmBeach]
			}
		}
	} else mem = NULL;
	
	sprintf(line, "[PalmBeach]\n");
	writeFile->Write(line, strlen(line));
	sprintf(line, "\tDataRate:%d\n", DataRate);
	writeFile->Write(line, strlen(line));
	sprintf(line, "\tPortName:%s\n", PortName);
	writeFile->Write(line, strlen(line));
//	sprintf(line, "\tMountPoint:%s\n", MountPoint);
//	writeFile->Write(line, strlen(line));

	if ((mem != NULL) && (c != NULL)) {
		c = strstr(c, "\n[");		// find beginning of the next sector
		if (c != NULL) {
			c++;
			writeFile->Write(c, size - (off_t )(c - mem));
		}
	}
	
	BEntry	*ent = new BEntry(dir, SETTING_BACKUP);	// rename the BACKUP-File to the correct one!
	ent->Rename(SETTING_FILE, true);
}

//===============================================================================
// We have to read all Settings from a file.
//
void SettingsView::LoadPreferences( void ) {

	BPath		path;
	BDirectory	*dir;
	BFile		*readFile;
	off_t		size;
	char		*mem, *begLine, *begValue, *nextLine;
	
//	strcpy(MountPoint, "/mnt/psion");						// Setup standard Value
	
	find_directory(B_USER_SETTINGS_DIRECTORY, &path);		// Find the Settings-directory
	dir = new BDirectory(path.Path());						// set a Directory

	readFile = new BFile(dir, SETTING_FILE, B_READ_ONLY);
	if (readFile->InitCheck() == B_OK) {
		readFile->GetSize(&size);
		if (( mem = (char *)malloc( size )) != NULL) {
			readFile->Read(mem, size);
			delete readFile;							// lets close the File!
			begLine = strstr(mem, "[PalmBeach]");
			if (begLine == NULL ) return;				// nothing found!

			nextLine = strchr(begLine, '\n');
			while (nextLine != NULL) {

				begLine = nextLine + 1;
				while (*begLine == ' ' || *begLine == '\t') begLine++;	// search for the first nonblank-character
				nextLine = strchr(begLine, '\n');
				if (nextLine != NULL) *nextLine = '\0';
				begValue = strchr(begLine, ':');
				if (begValue != NULL) *(begValue++) = '\0';
					
				if (strcmp(begLine, "DataRate") == 0) {
					DataRate = (data_rate ) atoi(begValue);
				} else if (strcmp(begLine, "PortName") == 0) {
					strcpy (PortName, begValue);
//				} else if (strcmp(begLine, "MountPoint") == 0) {
//					strcpy (MountPoint, begValue);
				}
			}
		}
	}
}
