//=====================================================================
// PsionSerialPort.h
// © Michael Pieper 28. Feb. 1999
//=====================================================================
//
//  
//
//=====================================================================

#ifndef PSION_SERIAL_PORT_H
#define PSION_SERIAL_PORT_H


#define P 0x1021					// The CRC-Polyvalue is x^16+x^12+x15+x^0

class PsionSerialPort : public BSerialPort
{
public:
					PsionSerialPort();
					~PsionSerialPort();
	void			SendMsg(unsigned char seqid, unsigned char frame_nr, NUCB *nucb, unsigned char *buffer, size_t len);

private:
	unsigned short	crctab[256];		// This is the CRC Lookuptable!
	void			CalcCRCTable(void);	// This function calculates the CRC-LookupTable
	unsigned short	CalcCRC(register unsigned short crc, register unsigned char *cp, register int len);
};

#endif
