//=====================================================================
// PsionSerialPort.cpp
// © Michael Pieper 28. Feb. 1999
//=====================================================================
//
//  This class is used to manage the SerialPort with the PSION Link Protocol
//
//=====================================================================

#include <stdio.h>
#include <stdlib.h>


#include "link.h"
#include "../messages.h"

//=====================================================================
// This Function is the constructor

PsionSerialPort::PsionSerialPort() {
	CalcCRCTable();
}

//=====================================================================
// This Function calculates the CRC-Lookuptable

void PsionSerialPort::CalcCRCTable (void) {
	register unsigned int b, v;
	register int i;
	for (b = 0; b < 256; b++) {
		v = b << 8;
		for (i = 8; i--; ) v = v & 0x8000 ? (v << 1) ^ P : v << 1;
		crctab[b] = v & 0xFFFF;
	}
}

//=====================================================================
// Eine CRC-Summe wird berechnet, indem man die folgende Funktion aufruft.
// der Wert crc ist dabei am Anfang auf 0 zu setzen.
// Will man mehrere Werte mit mehreren Aufrufen berechnen, so ist crc immer mit
// dem letzen Rückgabewert zu besetzen.

unsigned short PsionSerialPort::CalcCRC(register unsigned short crc, register unsigned char *cp, register int len)
{
	while (len--) crc = (crc << 8) ^ crctab[(crc >> 8 ^ *cp++) & 0xff];
	return (crc);
}

//=====================================================================
// die folgende Funktion schickt eine Nachricht über die Schnittstelle
// Kümmert sich um die ESC-Sequenzen und die CRC-Berechnung
// Framenr ist die Framenumerierung, die vor die Framedaten gesetzt werden!

void PsionSerialPort::SendMsg(unsigned char seqid, unsigned char frame_nr, NUCB *nucb, unsigned char *buffer, size_t len) {
								
	unsigned char	head[3]={ 0x16, 0x10, 0x02 };			// Header
	unsigned char	foot[4]={ 0x10, 0x03, 0x00, 0x00 };		// Footer + CRC-Summe
	unsigned char	id[3]={ 0x00, 0x00 };					// Kanalid's + Framenr.
	unsigned short	crc;
	unsigned char	*p, *start;
	
	crc = CalcCRC(0, &seqid, 1);							// Zur CRC gehört auch die Sequenzid
	if (nucb != NULL && nucb->remote_id != 0) {				// Die Kanalids werden nur verwendet, wenn's keine NCP verbindung oder LowLevel Protokoll ist
		id[0] = nucb->remote_id;
		id[1] = nucb->local_id;
		id[2] = frame_nr;
		crc = CalcCRC(crc, id, 3);							// Außerdem die Kanalid's
	}
	if (len > 0) crc = CalcCRC(crc, buffer, len);			// und die Daten an sich.
	
	foot[2] = crc >> 8;										// CRC-Summe setzen
	foot[3] = crc & 0xff;
	
	Write(head, 3);					// Header können wir bereits schicken
	Write(&seqid, 1);				// die Seuqenzid ebenfalls

//	printf("PC->PSION: 16 10 02 %02x ", seqid);

	if (nucb != NULL && nucb->remote_id != 0) {
		Write(id, 3);	// sowie die Kanalid's und die Framenr.
//		printf("%02x %02x %02x ", id[0], id[1], id[2]);
	}
	
//	for (int i = 0; i < len; printf("%02x ", buffer[i++])) ;
//	printf("10 03 %02x %02x\n", foot[2], foot[3]);
	
	if (len > 0) {
		p = start = buffer;
		while ((p = (unsigned char *)memchr(start, 0x10, len - (start-buffer))) != NULL) {
			Write(start, (p-start)+1);
			Write(p, 1);
			start = &p[1];
		}
		Write(start, len - (start-buffer));	// Rest schicken
	}
	Write(foot, 4);
}
