/*
	Dieses Programm öffnet eine Verbindung zum PSION
	Es übernimmt das Management des Linkprotokolls incl.
	CRC-Summe und Kanalnummern	
*/

#include "PsiNCPWindow.h"
#include "PsionNCP.h"
#include <stdio.h>
#include <StorageKit.h>
#include <TranslationKit.h>

#include "Icons/PsionBitmaps.h"		// Include the PSION-Volume Icon
#include "Icons/RawBitmaps.h"		// Include the PSION-Raw Data icon
#include "Icons/AgendaBitmaps.h"	// Include the PSION Agenda icon
#include "Icons/SheetBitmaps.h"		// Include the PSION Sheet icon
#include "Icons/DataBitmaps.h"		// Include the PSION Data icon
#include "Icons/JotterBitmaps.h"	// Include the PSION Jotter icon
#include "Icons/SoundBitmaps.h"		// Include the PSION Sound icon
#include "Icons/TextBitmaps.h"		// Include the PSION Text icon
#include "Icons/WordBitmaps.h"		// Include the PSION Word icon
#include "Icons/WorldBitmaps.h"		// Include the PSION Word icon

PsiNCPWindow	*myWindow;
BSerialPort		*Port;							// Der Zeiger auf den einen BSerialPort
BButton			*BButt_conn, *BButt_disc;		// Zwei Zeiger auf die Buttons connect und disconnect
data_rate		DataRate;						// Enthält aktuelle Datenrate
char			PortName[B_FILE_NAME_LENGTH];	// Enthält den Portnamen des seriellen Ports!
bool			connected;						// true = Verbindung hergestellt, Fenster darf nicht geschlossen werden!
bool			debug;							// true, dann wird für jeden Port eine Datei mitgeschrieben!

//=========================================================================================
//	We are declaring all MIME-Types which came from the PSION.
//=========================================================================================

myMimeType mime_values[] =	{ 
	{ "application/x-vnd.mp.psion-volume",	"PSION Volume", 	"PSION mounted volume", kLargePsionIconBits,	kSmallPsionIconBits,	kLargePsionIconColorSpace,	kSmallPsionIconColorSpace },
	{ "application/x-vnd.mp.psion",		 	"PSION Unknown Data","Unknown PSION data", 	kLargeRawIconBits,		kSmallRawIconBits,		kLargeRawIconColorSpace,	kSmallRawIconColorSpace },
	{ "application/x-vnd.mp.psion-agn", 	"PSION Agenda", 	"PSION Agenda file", 	kLargeAgendaIconBits,	kSmallAgendaIconBits,	kLargeAgendaIconColorSpace,	kSmallAgendaIconColorSpace },
	{ "application/x-vnd.mp.psion-spr", 	"PSION Spreadsheet","PSION Spread Sheet", 	kLargeSheetIconBits,	kSmallSheetIconBits,	kLargeSheetIconColorSpace,	kSmallSheetIconColorSpace },

	{ "application/x-vnd.mp.psion-dbf", 	"PSION Database",	"PSION Data file", 		kLargeDataIconBits,		kSmallDataIconBits,		kLargeDataIconColorSpace,	kSmallDataIconColorSpace },
//	{ "application/x-vnd.mp.psion-pic", 	"PSION Pictures",	"PSION Picture file", 	kLargePictureIconBits,	kSmallPictureIconBits,	kLargePictureIconColorSpace,kSmallPictureIconColorSpace },

	{ "application/x-vnd.mp.psion-jot", 	"PSION Jotter",		"PSION Jotter file", 	kLargeJotterIconBits,	kSmallJotterIconBits,	kLargeJotterIconColorSpace,	kSmallJotterIconColorSpace },
	{ "application/x-vnd.mp.psion-wld", 	"PSION World",		"PSION World file", 	kLargeWorldIconBits,	kSmallWorldIconBits,	kLargeWorldIconColorSpace,	kSmallWorldIconColorSpace },

	{ "text/x-vnd.mp.psion-wrd", 			"PSION Word",		"PSION Word file", 		kLargeWordIconBits,		kSmallWordIconBits,		kLargeWordIconColorSpace,	kSmallWordIconColorSpace },
	{ "text/x-vnd.mp.psion-txt", 			"PSION Text",		"PSION Text file", 		kLargeTextIconBits,		kSmallTextIconBits,		kLargeTextIconColorSpace,	kSmallTextIconColorSpace },

	{ "audio/x-vnd.mp.psion-wve", 			"PSION Sound",		"PSION Sound file", 	kLargeSoundIconBits,	kSmallSoundIconBits,	kLargeSoundIconColorSpace,	kSmallSoundIconColorSpace },

//	{ "application/x-vnd.mp.psion-app", 	"PSION Application","PSION Application (app)", 	kLargeAppIconBits,	kSmallAppIconBits,		kLargeAppIconColorSpace,	kSmallAppIconColorSpace },
//	{ "application/x-vnd.mp.psion-img", 	"PSION Application","PSION Application (img)", 	kLargeImgIconBits,	kSmallImgIconBits,		kLargeImgIconColorSpace,	kSmallImgIconColorSpace },
//	{ "application/x-vnd.mp.psion-opa", 	"PSION Application","PSION Application (opa)", 	kLargeOpaIconBits,	kSmallOpaIconBits,		kLargeOpaIconColorSpace,	kSmallOpaIconColorSpace },
//	{ "application/x-vnd.mp.psion-opl", 	"PSION Application","PSION Application (opl)", 	kLargeOplIconBits,	kSmallOplIconBits,		kLargeOplIconColorSpace,	kSmallOplIconColorSpace },
//	{ "application/x-vnd.mp.psion-opo", 	"PSION Application","PSION Application (opo)", 	kLargeOpoIconBits,	kSmallOpoIconBits,		kLargeOpoIconColorSpace,	kSmallOpoIconColorSpace },

//	{ "application/x-vnd.mp.psion-grp", 	"PSION Group",		"PSION Program group", 	kLargeGrpIconBits,		kSmallGrpIconBits,		kLargeGrpIconColorSpace,	kSmallGrpIconColorSpace },

	{ 0, 0, 0, 0, 0, B_COLOR_8_BIT , B_COLOR_8_BIT } 
	};

// Ab hier gehts los!

int main(int argc, char **argv)
{	
	PsionNCP	myPsiNCP;

//	PROFILE_INIT(10);
	myPsiNCP.Run();
//	PROFILE_DUMP("profile.datei");
	return(0);
}

// Programmstart

PsionNCP::PsionNCP() : BApplication( MY_MIME_TYPE )
{
	BRect			aRect;
	// set up a rectangle and instantiate a new window
	aRect.Set(100, 100, 500, 350);
	myWindow = new PsiNCPWindow(aRect);
	
	SetStdMime(mime_values);		// Set all needed MIME-Types
	myWindow->Show();				// make window visible
}

PsionNCP::~PsionNCP()				// There is nothing to do, when the program ends
{
}

//=======================================================================================
//	We have to set all MIME-Types. The Std.User of this Types is not PalmBeach!
//=======================================================================================

void PsionNCP::SetStdMime(myMimeType *mValue)	
{
	BMimeType	mime;
	BBitmap		large_icon(BRect(0, 0, B_LARGE_ICON - 1, B_LARGE_ICON - 1), B_COLOR_8_BIT);
	BBitmap		mini_icon(BRect(0, 0, B_MINI_ICON - 1, B_MINI_ICON - 1), B_COLOR_8_BIT);
	size_t		large_len = large_icon.BitsLength();
	size_t		mini_len = mini_icon.BitsLength();
	
	while (mValue->type != NULL) {
		mime.SetTo(mValue->type);
		if (!mime.IsInstalled()) mime.Install();

		large_icon.SetBits(mValue->large_bits, large_len, 0, mValue->large_colorSpace);
		mini_icon.SetBits(mValue->mini_bits, mini_len, 0, mValue->mini_colorSpace);

		mime.SetShortDescription(mValue->short_name);
		mime.SetLongDescription(mValue->long_name);
		mime.SetIcon(&large_icon, B_LARGE_ICON);
		mime.SetIcon(&mini_icon, B_MINI_ICON);
		mValue++;
	}
}
