//=====================================================================
// debugMsg.cpp
// © Michael Pieper 14. Feb. 1999
//=====================================================================
//
//  This class is used to write some DebugMessages into a file and to
//  the stdout-channel
//
//=====================================================================

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "debugMsg.h"

//==========================================================================
// The constructor deletes the file and writes a "hello"-Message to a file
//
DebugMsg::DebugMsg( char *file, char *server ) {
	
	time_t	tm;
	FILE	*fd_debug;

	if (file != NULL && server != NULL) {
		debugFilename = strdup( file );
		serverName = strdup ( server );
	
		if (debugFilename != NULL && serverName != NULL) {
			fd_debug = fopen(debugFilename, "w");
			if (fd_debug != NULL) {
				tm = time(NULL);
				fprintf(fd_debug, "%s: Startup! Timestamp: %s", serverName, ctime(&tm));

				fclose(fd_debug);
			}
		}
	} else {
		debugFilename = serverName = NULL;
	}
}
//============================================================================
// The constructor deletes the file and writes a "goodbye"-Message to a file
//
DebugMsg::~DebugMsg( void ) {
	
	time_t	tm;
	FILE	*fd_debug;

	if (debugFilename != NULL && serverName != NULL) {
		fd_debug = fopen(debugFilename, "a+");
		if (fd_debug != NULL) {
			tm = time(NULL);
			fprintf(fd_debug, "%s: Closed! Timestamp: %s", serverName, ctime(&tm));

			fclose(fd_debug);
		}
	}
	if (debugFilename != NULL) free (debugFilename);
	if (serverName != NULL) free (serverName);
}

//=====================================================================
// The Function prints out a string in a file and onto the screen
//
void DebugMsg::String( char *string ) {

	FILE	*fd_debug;
	
	if (debugFilename != NULL && serverName != NULL) {
		fd_debug = fopen(debugFilename, "a+");
		if (fd_debug != NULL) {
			fprintf(fd_debug, "%s: %s\n", serverName, string);
			printf( "%s: %s\n", serverName, string);
			fclose(fd_debug);
		}
	}
}

//=====================================================================
// The Function prints out a buffer only in the file!
//
void DebugMsg::Buffer( unsigned char *buffer, size_t len, char *message) {

	FILE	*fd_debug;
	size_t	i;
	
	if (debugFilename != NULL && serverName != NULL) {
		fd_debug = fopen(debugFilename, "a+");
		if (fd_debug != NULL) {
			if (message != NULL) {
				fprintf( fd_debug, "%s: %s\n", serverName, message );
				printf( "%s: %s\n", serverName, message );
			}
			fprintf(fd_debug, "    HEX: ");
			for (i = 0; i < len; fprintf(fd_debug, "%02x ", buffer[i++])) ;
			fprintf(fd_debug, "\n  ASCII: ");
			for (i = 0; i < len; i++) fprintf(fd_debug, " %c ", buffer[i] >= ' ' ? buffer[i] : '.');
			fprintf(fd_debug, "\n");
			fclose(fd_debug);
		}
	}
}

