/* ------------------------------------------------------------------ 

	Title: ListRsrc

	Description:  A utility for listing file resources

	Author :
		Stephen Wardlaw, M.D.
		Medical Research & Development
		Highrock
		Lyme, CT 06371

	Edit History:	
		04 September, 1999
			Created
		
------------------------------------------------------------------ */ 

#include <stdio.h>
#include <AppKit.h>
#include <StorageKit.h>
#include "WTextWindow.h"

class LRWindow : public WTextWindow {

	public :
	
		LRWindow(BRect frame, const char* name = "ListRsrc");
		
	virtual void
		MessageReceived(BMessage* theMesg);
};

// -------------------------------------------------------------------
//	* CONSTRUCTOR for LRWindow
// -------------------------------------------------------------------
LRWindow::LRWindow(BRect frame, const char* name): WTextWindow(frame,name)
{
}

void
LRWindow::MessageReceived(BMessage* theMesg)
{
	switch(theMesg->what) {
	
		case 'DATA' :
			be_app->RefsReceived(theMesg);
			break;
			
		default:
			BWindow::MessageReceived(theMesg);
	}
}


class ListRsrc : public BApplication {

	public:
		
		ListRsrc();
	
	protected: 	// Methods
	
	void
		FindResources(entry_ref* theRef);
		
	void
		Long2Str(int32 val,char* result);
		
	void
		MessageReceived(BMessage* theMesg);
		
	void
		RefsReceived(BMessage* theMesg);
		
	const char*
		TypeString(type_code theType);
		
	protected: 	// Data
	
	LRWindow*		mWindow;
	char			mText[32];
};

int 
main()
{
	ListRsrc theApp;
	theApp.Run();
	return 0;
}

ListRsrc::ListRsrc():BApplication("application/Test")
{
	BRect frame (100,100,350,450);
	mWindow = new LRWindow(frame);
	mWindow->Show();
	mWindow->SingleLine("Drop File In Window.");
	mWindow->NewLine();
}
// ------------------------------------------------------------------
void
ListRsrc::FindResources(entry_ref* theRef)
{
	char outStr[255];
	size_t length;
	const char*	rName;
	type_code	resType;
	int32	resID;

	BFile theFile(theRef,B_READ_ONLY);
	if(theFile.InitCheck() == B_OK) {
		BResources* theRes = new BResources(&theFile);
		int16 resIndx = 0;
		sprintf(outStr,"File Resources For: %s",theRef->name);
		mWindow->SingleLine(outStr);
		mWindow->NewLine();
		bool found = theRes->GetResourceInfo(resIndx++,&resType,&resID,&rName,&length);
		while (found) {
			sprintf(outStr,"Index  = %d",resIndx);
			mWindow->SingleLine(outStr);
			sprintf(outStr,"Type   = %s",TypeString(resType));
			mWindow->SingleLine(outStr);
			sprintf(outStr,"ID    = %8ld",resID);
			mWindow->Append(outStr);
			Long2Str(resID,outStr);
			if(outStr[0] > 0) {
				mWindow->Append(" / ");
				mWindow->Append(outStr);
			}
			mWindow->NewLine();
			//sprintf(outStr,"ID     = %ld",resID);
			//mWindow->SingleLine(outStr);
			sprintf(outStr,"Name   = %s",rName);
			mWindow->SingleLine(outStr);
			sprintf(outStr,"Length = %ld",length);
			found = theRes->GetResourceInfo(resIndx++,&resType,&resID,&rName,&length);
			mWindow->NewLine();
		}
		delete theRes;
	}
}		
// -------------------------------------------------------------------
void
ListRsrc::Long2Str(int32 val,char* result)
{
	int32 vals[4];
	int32 rem = val;
	int32 fact = 256*256*256;
	bool hasChar = false;
	for(int n = 0; n < 4; n++) {
		vals[n] = rem/fact;
		rem -= vals[n]*fact;
		fact /= 256;
		if(vals[n] > 0x30) {
			hasChar = true;
		}
	}
	if(hasChar) {
		sprintf(result,"%c%c%c%c",vals[0],vals[1],vals[2],vals[3]);
	} else {
		result[0] = 0;
	}
}
// ------------------------------------------------------------------
void
ListRsrc::MessageReceived(BMessage* theMesg)
{
	switch(theMesg->what) {
	
		default:
			BApplication::MessageReceived(theMesg);
	}
}
// ------------------------------------------------------------------
void
ListRsrc::RefsReceived(BMessage* theMesg)
{	
	entry_ref theRef;
	int16 indx = 0;
	while(theMesg->FindRef("refs",indx++,&theRef) == B_OK) {
		FindResources(&theRef);
	}
}		
// ------------------------------------------------------------------
const char*
ListRsrc::TypeString(type_code theType)
{
	switch (theType) {
		case B_ANY_TYPE :
			::strcpy(mText,"B_ANY_TYPE");
			break;
		case B_ASCII_TYPE :
			::strcpy(mText,"B_ASCII_TYPE");
			break;
		case B_BOOL_TYPE :
			::strcpy(mText,"B_BOOL_TYPE");
			break;
		case B_CHAR_TYPE :
			::strcpy(mText,"B_CHAR_TYPE");
			break;
		case B_COLOR_8_BIT_TYPE :
			::strcpy(mText,"B_COLOR_8_BIT_TYPE");
			break;
		case B_DOUBLE_TYPE :
			::strcpy(mText,"B_DOUBLE_TYPE");
			break;
		case B_FLOAT_TYPE :
			::strcpy(mText,"B_FLOAT_TYPE");
			break;
		case B_GRAYSCALE_8_BIT_TYPE :
			::strcpy(mText,"B_GRAYSCALE_8_BIT_TYPE");
			break;
		case B_INT64_TYPE :
			::strcpy(mText,"B_INT64_TYPE");
			break;
		case B_INT32_TYPE :
			::strcpy(mText,"B_INT32_TYPE");
			break;
		case B_INT16_TYPE :
			::strcpy(mText,"B_INT16_TYPE");
			break;
		case B_INT8_TYPE :
			::strcpy(mText,"B_INT8_TYPE");
			break;
		case B_MESSAGE_TYPE :
			::strcpy(mText,"B_MESSAGE_TYPE");
			break;
		case B_MESSENGER_TYPE :
			::strcpy(mText,"B_MESSENGER_TYPE");
			break;
		case B_MIME_TYPE :
			::strcpy(mText,"B_MIME_TYPE");
			break;
		case B_MONOCHROME_1_BIT_TYPE :
			::strcpy(mText,"B_MONOCHROME_1_BIT_TYPE");
			break;
		case B_OBJECT_TYPE :
			::strcpy(mText,"B_OBJECT_TYPE");
			break;
		case B_OFF_T_TYPE :
			::strcpy(mText,"B_OFF_T_TYPE");
			break;
		case B_PATTERN_TYPE :
			::strcpy(mText,"B_PATTERN_TYPE");
			break;
		case B_POINTER_TYPE :
			::strcpy(mText,"B_POINTER_TYPE");
			break;
		case B_POINT_TYPE :
			::strcpy(mText,"B_POINT_TYPE");
			break;
		case B_RAW_TYPE :
			::strcpy(mText,"B_RAW_TYPE");
			break;
		case B_RECT_TYPE :
			::strcpy(mText,"B_RECT_TYPE");
			break;
		case B_REF_TYPE :
			::strcpy(mText,"B_REF_TYPE");
			break;
		case B_RGB_32_BIT_TYPE :
			::strcpy(mText,"B_RGB_32_BIT_TYPE");
			break;
		case B_RGB_COLOR_TYPE :
			::strcpy(mText,"B_RGB_COLOR_TYPE");
			break;
		case B_SIZE_T_TYPE :
			::strcpy(mText,"B_SIZE_T_TYPE");
			break;
		case B_SSIZE_T_TYPE :
			::strcpy(mText,"B_SSIZE_T_TYPE");
			break;
		case B_STRING_TYPE :
			::strcpy(mText,"B_STRING_TYPE");
			break;
		case B_TIME_TYPE :
			::strcpy(mText,"B_TIME_TYPE");
			break;
		case B_UINT64_TYPE :
			::strcpy(mText,"B_UINT64_TYPE");
			break;
		case B_UINT32_TYPE :
			::strcpy(mText,"B_UINT32_TYPE");
			break;
		case B_UINT16_TYPE :
			::strcpy(mText,"B_UINT16_TYPE");
			break;
		case B_UINT8_TYPE :
			::strcpy(mText,"B_UINT8_TYPE");
			break;
		case B_MEDIA_PARAMETER_TYPE :
			::strcpy(mText,"B_MEDIA_PARAMETER_TYPE");
			break;
		case B_MEDIA_PARAMETER_WEB_TYPE :
			::strcpy(mText,"B_MEDIA_PARAMETER_WEB_TYPE");
			break;
		case B_MEDIA_PARAMETER_GROUP_TYPE :
			::strcpy(mText,"B_MEDIA_PARAMETER_GROUP_TYPE");
			break;
		default :
			Long2Str(theType,mText);
	}
	return mText;
}
// ------------------------------------------------------------------
		
