//fontData.cpp
/*
I borrowed this stuff, see:

This archive includes code to help in manipulating BFont objects in
BMessages.  The code is contained in the files FFont.cpp and FFont.h,
which can be copied for use in your own projects.  The example project
TestFFont.proj creates a small application called TestFFont that,
when run from the terminal, will print out some basic diagnostics on
how the FFont package is working.

See the file FFont.html for more information.  Note that this
documentation was written very quickly just to get something out.  It
has been minimally proof-read, so there are surely lots of spelling
mistakes and problems.  Please feel free to e-mail me with any
questions, suggestions, or corrections.

-- Dianne Hackborn <hackbod@lucent.com>, Sept. 22, 1997
*/

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "fontData.h"
#include "warning.h"
#include "Preferences.h"
#include "myPreferences.h"


FontData		::	 ~FontData()
{
//left blank
}//end


FontData		::	 FontData(	void)
{
	try
	{
		BFont *	tempBFont = new BFont();
		size = tempBFont->Size();
		shear = tempBFont->Shear();
		rotation = tempBFont->Rotation();
		flags = tempBFont->Flags();
		face = tempBFont->Face();
		spacing = tempBFont->Spacing();
		familyAndStyle = tempBFont->FamilyAndStyle();
		delete tempBFont;
	}
	catch(...)
	{
		warning(myPrefs->FailMemory);
		size = 12;
		shear = 90;
		rotation = 0;
		flags = 0;
		face = 0;
		spacing = 2;
		familyAndStyle = 131072;
	}
}//end


FontData		::	 FontData(	const BFont * pparamFont)
{
	size = pparamFont->Size();
	shear = pparamFont->Shear();
	rotation = pparamFont->Rotation();
	flags = pparamFont->Flags();
	face = pparamFont->Face();
	spacing = pparamFont->Spacing();
	familyAndStyle = pparamFont->FamilyAndStyle();
}//end