//floatGadget.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "layoutMatrixItem.h"
#include "floatGadget.h"
#include "Preferences.h"
#include "myroColour.h"
#include "layoutMatrix.h"
#include "myPreferences.h"
#include "warning.h"

FloatGadget	::	~FloatGadget() 
{
	//left blank
};//end


//ctor
FloatGadget	::	FloatGadget(	float fparamInitValue,
						const char * paramName, 
						const char * paramLabel, 
						uint32 ui32paramMsg, 
						float fparamPixWidth,
						LayoutMatrix * lpparamLayoutMatrix,
						bool bparamMakeFocus) 
		: 	BTextControl(	BRect(0, 0, 32, 32), 
							paramName, 
							paramLabel, 
							NULL, 
							new BMessage(ui32paramMsg), 
							B_FOLLOW_NONE, 
							B_WILL_DRAW | B_NAVIGABLE),
			 bmMakeFocus(	bparamMakeFocus)
{
	try
	{
		LayoutMatrixItem * lmi = new LayoutMatrixItem(	(void *)this,
														lpparamLayoutMatrix,
														KIND_FLOATGADG);
		lpparamLayoutMatrix->mpLayoutMatrixItems->AddItem((void *)lmi);
	}
	catch (...)
	{
		warning(myPrefs->FailMemory);
		return;
	}
	lpparamLayoutMatrix->AddToChildren(this);
	SetFont(myPrefs->GetPreferredFont());
	char buf[64];
	sprintf(buf, "%f", fparamInitValue);
	SetText(buf);
	if (fparamPixWidth)
	{
		mfPixWidth = fparamPixWidth;
	}
	else
	{
		BView bv(BRect(0, 0, 32, 32), "NoShowView", B_FOLLOW_NONE, 0);
		bv.SetFont(myPrefs->GetPreferredFont());
		mfPixWidth = bv.StringWidth(paramLabel);
	}
}//end


void 
FloatGadget	::	AttachedToWindow(	void)
{
	SetDrawingMode(B_OP_ADD);
	BTextControl::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredFloatGadgetHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredFloatGadgetLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredFloatGadgetViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
	if (bmMakeFocus) 
	{
		MakeFocus();
	}
}//end
