/*
 * ID3tag
 *
 * TagWin.h - Window header file
 * Copyright (c) 1999 Pieter Panman (ppanman@dds.nl)
 * Based very partially on ID3ren (by Robert Alto (badcrc@tscnet.com)
 * and its BeOS port by Shayne White (shayne@curvedspace.org))
 * (I only used the genre list and some ideas)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */


#ifndef _TAGWIN_H_
#define _TAGWIN_H_

#include <Application.h>
#include <Window.h>
#include <Button.h>
#include <TextControl.h>
#include <FilePanel.h>
#include <Path.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <MenuField.h>
#include <View.h>
#include <Box.h>
#include <Alert.h>
#include <stdio.h>
#include <string.h>

#define BUTTON_APP			'APPL'
#define BUTTON_RET			'RETR'
#define BUTTON_DELETE_TAG	'DELE'
#define BUTTON_BROWSE		'BRWS'
#define TEXTCT_ARTIST		'ARTS'
#define TEXTCT_SONGNAME		'SONG'
#define TEXTCT_ALBUM		'ALBM'
#define TEXTCT_YEAR			'YEAR'
#define TEXTCT_GENRE		'GENR'
#define TEXTCT_COMMENTS		'COMM'
#define TEXTCT_FILE			'FILE'

class TagWin : public BWindow
{
	public:
							TagWin();
		virtual bool		QuitRequested();
		virtual void		MessageReceived(BMessage* message);
		virtual void		FrameResized(float w, float h);
		virtual void		ErrorDialog(char* title, char* text, char* buttonText);
		virtual void		RetrieveFromFile(BFile* myFile);
		virtual void		ApplyToFile(BFile* myFile);
		virtual bool		ValidExtension(char* extension);
		virtual bool		OpenFile(char* path, BFile* myFile, int openMode);
		virtual void		RemoveID3tag(BFile* myFile);


		BTextControl*		fTC;
		BButton*		aButton;
		BButton*		dButton;
		BButton*		bButton;
		struct id3struct {
			char tag[4];
			char songname[31];
			char artist[31];
			char album[31];
			char year[5];
			char comment[31];
			int genre;
		}					*id3tag;

	private:
		BBox*			mainBox;
		BTextControl*	aTC;
		BTextControl*	sTC;
		BTextControl*	lTC;
		BTextControl*	yTC;
		BMenuField*		gMF;
		BTextControl*	cTC;
		BFilePanel*		OpenPanel;
		BBox*			box;
		BRect			rect;
		BPopUpMenu		*genrePopup;
		BMenuField		*genreField;
		BAlert			*myAlert;
		BMessage		*msg;
};

#endif
