/*
 * ID3tag
 *
 * ID3tag.cpp - main file
 * Copyright (c) 1999 Pieter Panman (ppanman@dds.nl)
 * Based very partially on ID3ren (by Robert Alto (badcrc@tscnet.com)
 * and its BeOS port by Shayne White (shayne@curvedspace.org))
 * (I only used the genre list and some ideas)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#include "ID3tag.h"
#include "TagWin.h"

// VERSION  "0.9b"

/*
  ==========================================
	main()
  ==========================================
*/

main()
{
	TagApp* app = new TagApp();
	app->Run();
	
	return(0);
}

/*
  ==========================================
	TagApp::TagApp():BApplication
  ==========================================
*/

TagApp::TagApp():BApplication(ID3TAG_APP_SIG)
{
}

/*
  ==========================================
	TagApp::ReadyToRun
  ==========================================
*/

void TagApp::ReadyToRun()
{
	fWindow = new TagWin();
	fWindow->Show();
}

/*
  ==========================================
	TagApp::RefsReceived
  ==========================================
*/

void TagApp::RefsReceived(BMessage *message) {
	entry_ref 	ref;		// The entry_ref to open
	status_t 	err;		// The error code
	int32		ref_num;	// The index into the ref list
	BPath path;
	BFile		myFile;
	// Loop through the ref list and open each one

	ref_num = 0;
	do {
		if ((err = message->FindRef("refs", ref_num, &ref)) != B_OK) {
			return;
		}
		BEntry entry(&ref, true);
		if ( entry.IsFile() && entry.GetPath(&path)==B_OPEN){
			fWindow->Lock();

			// Retrieve new data from file
			fWindow->fTC->SetText(path.Path());
			if (fWindow->OpenFile((char *)path.Path(), &myFile, B_READ_ONLY))
			{
				fWindow->RetrieveFromFile(&myFile);
				fWindow->aButton->MakeDefault(true);
				myFile.Unset();
			}

			fWindow->Unlock();
		}
		ref_num++;
	} while (1);
}