//scrolling fontPref window


#include "windowGuts.h"
#include "s2f.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "preferences.h"
#include "myTextView.h"
#include "myButton.h"
#include "intGadget.h"
#include "stringGadget.h"
#include "myPictureButton.h"
#include "myStatusBar.h"
#include "myRadioView.h"
#include "myCheckBox.h"
#include "myColorControl.h"
#include "colorWell.h"
#include "prefPanelWindow.h"
#include "myPreferences.h"
#include "specificColorWindow.h"
#include "warning.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"
#include <memory>

//ctor
SpecificColorWindow	::	SpecificColorWindow(	BRect paramBound,
												uint32 ui32paramkind)
				: 
				WindowGuts(	paramBound, 
							lccpWindowTitle[ui32paramkind], 
							lccpScrollViewName[ui32paramkind],
							lccpNamePrefFrame[ui32paramkind]),
				kind(ui32paramkind)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning("Could not create_sem.\n");
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		BWindow bw(	BRect(0, 0, 32, 32), 
					"noshow", 
					B_DOCUMENT_WINDOW, 
					/*B_WILL_ACCEPT_FIRST_CLICK*/0);
		auto_ptr<LayoutMatrix> apSpecificColorWindowLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 1, 1));//rows,columns
		LayoutMatrix *	pholdTitleLayoutMatrix = apSpecificColorWindowLayoutMatrix.get();
		apSpecificColorWindowLayoutMatrix.release();
		AddToLayoutMatrixList(pholdTitleLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apBFont(new BFont());//note-- using system be_plain_font
		BFont * pBFont = apBFont.get();//NOT preferredFont(), just for something different
		apBFont.release();
		float fontSize = pBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pBFont->SetSize(fontSize);
		pBFont->SetShear(122);
		//will need offset for demo--use a seperate matrix and get it's bottom
		auto_ptr<MyStringDrawer> apMyStringDrawer(new MyStringDrawer(	"specificTitleMyStringDrawer", 
																		lccpWindowTitle[kind], 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFont));
		MyStringDrawer * pMyStringDrawer = apMyStringDrawer.get();
		apMyStringDrawer.release();
		pMyStringDrawer->SetFont(myPrefs->GetPreferredFont());
		pholdTitleLayoutMatrix->AddToChildren((void *)pMyStringDrawer);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pMyStringDrawer, 
																							pholdTitleLayoutMatrix->itemsList,
																							KIND_STRINGDRAWER));
/////////////////////////////
		LayoutMatrix *	pholdViewCCLayoutMatrix;
		auto_ptr<LayoutMatrix> apColorControlLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 2, 1));//rows,columns
		pholdViewCCLayoutMatrix = apColorControlLayoutMatrix.get();
		apColorControlLayoutMatrix.release();
		AddToLayoutMatrixList(pholdViewCCLayoutMatrix);
		rgb_color color;//re-use for every setvalue
/////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apBFontAXX(new BFont(myPrefs->GetPreferredFont()));
		BFont * pBFontAXX = apBFontAXX.get();
		apBFontAXX.release();
		auto_ptr<MyStringDrawer> apMyStringDrawerAXX(new MyStringDrawer(	"MyStringDrawerAXX", 
																			"Set View color:", 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			pBFontAXX));
		MyStringDrawer * pMyStringDrawerAXX = apMyStringDrawerAXX.get();
		apMyStringDrawerAXX.release();
		pholdViewCCLayoutMatrix->AddToChildren((void *)pMyStringDrawerAXX);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerAXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)pMyStringDrawerAXX, 
																								pholdViewCCLayoutMatrix->itemsList,
																								KIND_STRINGDRAWER));
////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> colorControlAXXMsg(new BMessage(COLORCONTROL_VIEW));
		auto_ptr<MyColorControl> apColorControlAXX(new MyColorControl(	BPoint(1, 1), 
																				B_CELLS_8x32,//lots of other options! Make a pref??
																				1,
																				"ColorControlAXX", 
																				colorControlAXXMsg.get(), 
																				true,
																				this));
		colorControlAXXMsg.release();
		pmViewColorControl = apColorControlAXX.get();
		apColorControlAXX.release();
		switch (kind)
		{
			case SPECIFIC_COLOR_BUTTON:
				myPrefs->GetPreferredMyButtonViewColor(&color);
				pmViewColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_PICTURE:
				myPrefs->GetPreferredMyPictureButtonViewColor(&color);
				pmViewColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_RADIOVIEW:
				myPrefs->GetPreferredMyRadioViewViewColor(&color);
				pmViewColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_CHECKBOX:
				myPrefs->GetPreferredMyCheckBoxViewColor(&color);
				pmViewColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_STATUSBAR:
				myPrefs->GetPreferredMyStatusBarViewColor(&color);
				pmViewColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_COLORCONTROL:
				myPrefs->GetPreferredMyColorControlViewColor(&color);
				pmViewColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_TEXTVIEW:
				myPrefs->GetPreferredMyTextViewViewColor(&color);
				pmViewColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_INTGADG:
				myPrefs->GetPreferredIntGadgetViewColor(&color);
				pmViewColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_STRINGGADG:
				myPrefs->GetPreferredStringGadgetViewColor(&color);
				pmViewColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_COLORWELL:
				myPrefs->GetPreferredColorWellViewColor(&color);
				pmViewColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_STRINGDRAWER:
				myPrefs->GetPreferredMyStringDrawerViewColor(&color);
				pmViewColorControl->SetValue(color);
			break;
			default:
				warning("Bad specific color kind view ctor.");
				throw;
			break;
		}
		pholdViewCCLayoutMatrix->AddToChildren((void *)pmViewColorControl);
		auto_ptr<LayoutMatrixItem> apColorControlAXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pmViewColorControl, 
																							pholdViewCCLayoutMatrix->itemsList,
																							KIND_MYCOLORCONTROL));
/////////////////////
		LayoutMatrix *	pholdHighCCLayoutMatrix;
		auto_ptr<LayoutMatrix> apHighColorControlLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 2, 1));//rows,columns
		pholdHighCCLayoutMatrix = apHighColorControlLayoutMatrix.get();
		apHighColorControlLayoutMatrix.release();
		AddToLayoutMatrixList(pholdHighCCLayoutMatrix);
////////////////////////////////
		auto_ptr<BFont> apBFontBXX(new BFont(myPrefs->GetPreferredFont()));
		BFont * pBFontBXX = apBFontBXX.get();
		apBFontBXX.release();
		auto_ptr<MyStringDrawer> apMyStringDrawerBXX(new MyStringDrawer(	"MyStringDrawerBXX", 
																		"Set High color:", 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFontBXX));
		MyStringDrawer * pMyStringDrawerBXX = apMyStringDrawerBXX.get();
		apMyStringDrawerBXX.release();
		pholdHighCCLayoutMatrix->AddToChildren((void *)pMyStringDrawerBXX);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerBXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)pMyStringDrawerBXX, 
																								pholdHighCCLayoutMatrix->itemsList,
																								KIND_STRINGDRAWER));
/////////////////////////////////////////////
		auto_ptr<BMessage> colorControlBXXMsg(new BMessage(COLORCONTROL_HIGH));
		auto_ptr<MyColorControl> apHighColorControlBXX(new MyColorControl(	BPoint(1, 1), 
																					B_CELLS_8x32,
																					1,
																					"HighColorControlBXX", 
																					colorControlBXXMsg.get(), 
																					true,
																					this));
		colorControlBXXMsg.release();
		pmHighColorControl = apHighColorControlBXX.get();
		apHighColorControlBXX.release();
		switch (kind)
		{
			case SPECIFIC_COLOR_BUTTON:
				myPrefs->GetPreferredMyButtonHighColor(&color);
				pmHighColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_PICTURE:
				myPrefs->GetPreferredMyPictureButtonHighColor(&color);
				pmHighColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_RADIOVIEW:
				myPrefs->GetPreferredMyRadioViewHighColor(&color);
				pmHighColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_CHECKBOX:
				myPrefs->GetPreferredMyCheckBoxHighColor(&color);
				pmHighColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_STATUSBAR:
				myPrefs->GetPreferredMyStatusBarHighColor(&color);
				pmHighColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_COLORCONTROL:
				myPrefs->GetPreferredMyColorControlHighColor(&color);
				pmHighColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_TEXTVIEW:
				myPrefs->GetPreferredMyTextViewHighColor(&color);
				pmHighColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_INTGADG:
				myPrefs->GetPreferredIntGadgetHighColor(&color);
				pmHighColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_STRINGGADG:
				myPrefs->GetPreferredStringGadgetHighColor(&color);
				pmHighColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_COLORWELL:
				myPrefs->GetPreferredColorWellHighColor(&color);
				pmHighColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_STRINGDRAWER:
				myPrefs->GetPreferredMyStringDrawerHighColor(&color);
				pmHighColorControl->SetValue(color);
			break;
			default:
				warning("Bad specific color kind high ctor.");
				throw;
			break;
		}
		pholdHighCCLayoutMatrix->AddToChildren((void *)pmHighColorControl);
		auto_ptr<LayoutMatrixItem> apHighColorControlBXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pmHighColorControl, 
																							pholdHighCCLayoutMatrix->itemsList,
																							KIND_MYCOLORCONTROL));
//////////////////////////////////////////////////////////////
		LayoutMatrix *	pholdLowCCLayoutMatrix;
		auto_ptr<LayoutMatrix> apLowColorControlLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 2, 1));//rows,columns
		pholdLowCCLayoutMatrix = apLowColorControlLayoutMatrix.get();
		apLowColorControlLayoutMatrix.release();
		AddToLayoutMatrixList(pholdLowCCLayoutMatrix);
///////////////////////////////////////////////////
		auto_ptr<BFont> apBFontCXX(new BFont(myPrefs->GetPreferredFont()));
		BFont * pBFontCXX = apBFontCXX.get();
		apBFontCXX.release();
		auto_ptr<MyStringDrawer> apMyStringDrawerCXX(new MyStringDrawer(	"MyStringDrawerCXX", 
																		"Set Low color:", 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFontCXX));
		MyStringDrawer * pMyStringDrawerCXX = apMyStringDrawerCXX.get();
		apMyStringDrawerCXX.release();
		pholdLowCCLayoutMatrix->AddToChildren((void *)pMyStringDrawerCXX);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerCXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)pMyStringDrawerCXX, 
																								pholdLowCCLayoutMatrix->itemsList,
																								KIND_STRINGDRAWER));
///////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> colorControlCXXMsg(new BMessage(COLORCONTROL_LOW));
		auto_ptr<MyColorControl> apLowColorControlCXX(new MyColorControl(	BPoint(1, 1), 
																				B_CELLS_8x32,
																				1,
																				"LowColorControlCXX", 
																				colorControlCXXMsg.get(), 
																				true,
																				this));
		colorControlCXXMsg.release();
		pmLowColorControl = apLowColorControlCXX.get();
		apLowColorControlCXX.release();
		switch (kind)
		{
			case SPECIFIC_COLOR_BUTTON:
				myPrefs->GetPreferredMyButtonLowColor(&color);
				pmLowColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_PICTURE:
				myPrefs->GetPreferredMyPictureButtonLowColor(&color);
				pmLowColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_RADIOVIEW:
				myPrefs->GetPreferredMyRadioViewLowColor(&color);
				pmLowColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_CHECKBOX:
				myPrefs->GetPreferredMyCheckBoxLowColor(&color);
				pmLowColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_STATUSBAR:
				myPrefs->GetPreferredMyStatusBarLowColor(&color);
				pmLowColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_COLORCONTROL:
				myPrefs->GetPreferredMyColorControlLowColor(&color);
				pmLowColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_TEXTVIEW:
				myPrefs->GetPreferredMyTextViewLowColor(&color);
				pmLowColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_INTGADG:
				myPrefs->GetPreferredIntGadgetLowColor(&color);
				pmLowColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_STRINGGADG:
				myPrefs->GetPreferredStringGadgetLowColor(&color);
				pmLowColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_COLORWELL:
				myPrefs->GetPreferredColorWellLowColor(&color);
				pmLowColorControl->SetValue(color);
			break;
			case SPECIFIC_COLOR_STRINGDRAWER:
				myPrefs->GetPreferredMyStringDrawerLowColor(&color);
				pmLowColorControl->SetValue(color);
			break;
			default:
				warning("Bad specific color kind low ctor.");
				throw;
			break;
		}                         
		pholdLowCCLayoutMatrix->AddToChildren((void *)pmLowColorControl);
		auto_ptr<LayoutMatrixItem> apLowColorControlCXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pmLowColorControl, 
																							pholdLowCCLayoutMatrix->itemsList,
																							KIND_MYCOLORCONTROL));
////////////////////////
		LayoutMatrix * pholdColorWellLayoutMatrix;
		auto_ptr<LayoutMatrix> apColorWellLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 3, 1));//rows,columns
		pholdColorWellLayoutMatrix = apColorWellLayoutMatrix.get();
		apColorWellLayoutMatrix.release();
		AddToLayoutMatrixList(pholdColorWellLayoutMatrix);
//////////////
		auto_ptr<TextItem> apMainViewColorWellText(new TextItem("main view roColor>"));
		TextItem * pholdMainViewColorWellText = apMainViewColorWellText.get();
		apMainViewColorWellText.release();
		pholdColorWellLayoutMatrix->AddToDraw((void *)pholdMainViewColorWellText);
		auto_ptr<ColorWell> apMainViewColorWell(new ColorWell(	"ColorWellViewColorPref", 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			VIEW_COLOR,
																			pholdMainViewColorWellText));
		ColorWell * pholdMainViewColorWell = apMainViewColorWell.get();
		apMainViewColorWell.release();
		pholdColorWellLayoutMatrix->AddToChildren((void *)pholdMainViewColorWell);
		auto_ptr<LayoutMatrixItem> apMainViewLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pholdMainViewColorWell, 
																					pholdColorWellLayoutMatrix->itemsList,
																					KIND_COLORWELLGADG));
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apMainHighColorWellText(new TextItem("main high roColor>"));
		TextItem * pholdMainHighColorWellText = apMainHighColorWellText.get();
		apMainHighColorWellText.release();
		pholdColorWellLayoutMatrix->AddToDraw((void *)pholdMainHighColorWellText);
		auto_ptr<ColorWell> apMainHighColorWell(new ColorWell(	"ColorWellHighColorPref", 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			HIGH_COLOR,
																			pholdMainHighColorWellText));
		ColorWell * pholdMainHighColorWell = apMainHighColorWell.get();
		apMainHighColorWell.release();
		pholdColorWellLayoutMatrix->AddToChildren((void *)pholdMainHighColorWell);
		auto_ptr<LayoutMatrixItem> apMainHighLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pholdMainHighColorWell, 
																					pholdColorWellLayoutMatrix->itemsList,
																					KIND_COLORWELLGADG));
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apMainLowColorWellText(new TextItem("main low roColor>"));
		TextItem * pholdMainLowColorWellText = apMainLowColorWellText.get();
		apMainLowColorWellText.release();
		pholdColorWellLayoutMatrix->AddToDraw((void *)pholdMainLowColorWellText);
		auto_ptr<ColorWell> apMainLowColorWell(new ColorWell(	"ColorWellLowColorPref", 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			LOW_COLOR,
																			pholdMainLowColorWellText));
		ColorWell * pholdMainLowColorWell = apMainLowColorWell.get();
		apMainLowColorWell.release();
		pholdColorWellLayoutMatrix->AddToChildren((void *)pholdMainLowColorWell);
		auto_ptr<LayoutMatrixItem> apMainLowLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pholdMainLowColorWell, 
																					pholdColorWellLayoutMatrix->itemsList,
																					KIND_COLORWELLGADG));
///////////////////////////////////////////////////////////////////////
		LayoutMatrix * pholdDemoLayoutMatrix;
		auto_ptr<LayoutMatrix> apDemoLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 1, 1));//rows,columns
		pholdDemoLayoutMatrix = apDemoLayoutMatrix.get();
		apDemoLayoutMatrix.release();
		AddToLayoutMatrixList(pholdDemoLayoutMatrix);
//////////////////////////////////
		int32 kindDemo;
		void * pholdDemo;
		void * addMeToDraw = NULL;
		switch (kind)
		{
			case SPECIFIC_COLOR_BUTTON:
			{
				BMessage * buttonDemoMsg = new BMessage(DEMOBUTTONMSG);
				MyButton * pholdDemoMyButton = new MyButton(	"demoButton", 
																			"Button", 
																			buttonDemoMsg, 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW);
				pholdDemoMyButton->SetFont(myPrefs->GetPreferredFont());
				kindDemo = KIND_MYBUTTON;
				pholdDemo = (void *)pholdDemoMyButton;
			break;
			}
			case SPECIFIC_COLOR_PICTURE:
			{
				BMessage * pPictureButtonDemoMsg = new BMessage(DEMOPICTUREBUTTONMSG);
				BPicture * pOnPicture;
				BPicture * pOnDisabledPicture;
				BPicture * pOffPicture;
				BPicture * pOffDisabledPicture;
				BWindow bwn(	BRect(0, 0, 32, 32), 
								"noshow", 
								B_DOCUMENT_WINDOW, 
								/*B_WILL_ACCEPT_FIRST_CLICK*/0);
				BView bv(BRect(0, 0, 32, 32), "noView", B_FOLLOW_NONE, B_WILL_DRAW);
				bwn.AddChild(&bv);
				bv.BeginPicture(new BPicture);
				bv.MoveTo(5, 5);
				bv.StrokeRect(BRect(0,0,8,8));
				pOffPicture = bv.EndPicture();
				
				bv.BeginPicture(new BPicture);
				bv.MoveTo(10, 5);
				bv.StrokeRect(BRect(0,0,10,15));
				pOnPicture = bv.EndPicture();
				
				bv.BeginPicture(new BPicture);
				bv.MoveTo(2, 5);
				bv.FillRect(BRect(0,0,22,20));
				pOffDisabledPicture = bv.EndPicture();
				bv.BeginPicture(new BPicture);
				bv.MoveTo(1, 5);
				bv.FillRect(BRect(0,0,6,15));
				pOnDisabledPicture = bv.EndPicture();
				bv.RemoveSelf();
				MyPictureButton * pholdDemoMyPictureButton = new MyPictureButton(	BRect(0, 0, 32, 32),
																								"DemoPictureButton", 
																								pOffPicture,
																								pOnPicture,
																								pOffDisabledPicture,
																								pOnDisabledPicture,
																								pPictureButtonDemoMsg, 
																								B_TWO_STATE_BUTTON,//B_ONE_STATE_BUTTON
																								B_FOLLOW_NONE, 
																								B_WILL_DRAW);
				pholdDemoMyPictureButton->SetFont(myPrefs->GetPreferredFont());
				kindDemo = KIND_MYPICTUREBUTTON;
				pholdDemo = (void *)pholdDemoMyPictureButton;
			break;
			}
			case SPECIFIC_COLOR_RADIOVIEW:
			{
				BList * pBList = new BList();
				RadioViewData * pRadioViewDataOne = new RadioViewData();
				pRadioViewDataOne->ccpmLabel = "one";
				BMessage * pOneMsg = new BMessage('_one');
				pRadioViewDataOne->pmMsg = pOneMsg;
				pBList->AddItem((void *)pRadioViewDataOne);
				
				RadioViewData * pRadioViewDataTwo = new RadioViewData();
				pRadioViewDataTwo->ccpmLabel = "twice";
				BMessage * pTwoMsg = new BMessage('_two');
				pRadioViewDataTwo->pmMsg = pTwoMsg;
				pBList->AddItem((void *)pRadioViewDataTwo);
				
				RadioViewData * pRadioViewDataThree = new RadioViewData();
				pRadioViewDataThree->ccpmLabel = "troi";
				BMessage * pThreeMsg = new BMessage('thre');
				pRadioViewDataThree->pmMsg = pThreeMsg;
				pBList->AddItem((void *)pRadioViewDataThree);
				
				MyRadioView * pholdMyRadioView = new MyRadioView(	"firstRadio",
																	false,//true gives vertical orientation
																	pBList,
																	myPrefs->GetPreferredFont());
				bool success = pholdMyRadioView->Initialize();
				if (!success)
				{
					warning("Radio View demo failed Initialize.\n");
					throw;
				}
				kindDemo = KIND_MYRADIOVIEW;
				pholdDemo = (void *)pholdMyRadioView;
			break;
			}
			case SPECIFIC_COLOR_CHECKBOX:
			{
				BMessage * checkBoxMsg = new BMessage(DEMOCHECKBOXMSG);
				MyCheckBox * pholdCheckBox = new MyCheckBox(	"checkBox", 
																		"Check me out!", 
																		checkBoxMsg, 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW);
				pholdCheckBox->SetFont(myPrefs->GetPreferredFont());
				kindDemo = KIND_MYCHECKBOX;
				pholdDemo = (void *)pholdCheckBox;
			break;
			}
			case SPECIFIC_COLOR_STATUSBAR:
			{
				MyStatusBar * pholdStatusBar = new MyStatusBar(	BRect(1, 1, 32, 32), 
																		"StatusBarname", 
																		"leading label: ", 
																		" trailing label",
																		0);
				pholdStatusBar->SetFont(myPrefs->GetPreferredFont());
				kindDemo = KIND_MYSTATUSBAR;
				pholdDemo = (void *)pholdStatusBar;
			break;
			}
			case SPECIFIC_COLOR_COLORCONTROL:
			{
				BMessage * colorControlMsg = new BMessage(DEMOCOLORCONTROLMSG);
				MyColorControl * pholdColorControl = new MyColorControl(	BPoint(1, 1), 
																					B_CELLS_8x32,
																					1,
																					"ColorControl", 
																					colorControlMsg, 
																					true,
																					this);
			
				kindDemo = KIND_MYCOLORCONTROL;
				pholdDemo = (void *)pholdColorControl;
			break;
			}
			case SPECIFIC_COLOR_TEXTVIEW:
			{
				BWindow bwn(	BRect(0, 0, 32, 32), 
							"noshow", 
							B_DOCUMENT_WINDOW, 
							/*B_WILL_ACCEPT_FIRST_CLICK*/0);
				BView bv(BRect(0, 0, 32, 32), "noView", B_FOLLOW_NONE, B_WILL_DRAW);
				bwn.AddChild(&bv);
				bv.SetFont(myPrefs->GetPreferredFont());
				font_height	fontHeight;
				bv.GetFontHeight(&fontHeight);
				float stringEntryPixHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
				float stringEntryPixWidth = bv.StringWidth("Put some string data here:");
				bv.RemoveSelf();
				MyTextView * pholdTextView = new MyTextView(	"textView", 
																	NULL, 
																	stringEntryPixWidth,
																	6 * stringEntryPixHeight);//allow 6 lines visible
				pholdTextView->SetFont(myPrefs->GetPreferredFont());
				kindDemo = KIND_MYTEXTVIEW;
				pholdDemo = (void *)pholdTextView;
			break;
			}
			case SPECIFIC_COLOR_INTGADG:
			{
				char wrapAtStr[16];
				sprintf(wrapAtStr, "%u", 123);
				BMessage * pIntGadgetMsg = new BMessage(DEMOINTGADGMSG);
				IntGadget * pholdIntGadget = new IntGadget(	BRect(10, 100, 300, 110), 
														"intGadget", 
														"put an integer here:", 
														wrapAtStr, 
														pIntGadgetMsg, 
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE);
				pholdIntGadget->SetFont(myPrefs->GetPreferredFont());
				kindDemo = KIND_INTGADG;
				pholdDemo = (void *)pholdIntGadget;
			break;
			}
			case SPECIFIC_COLOR_STRINGGADG:
			{
				BWindow bwn(	BRect(0, 0, 32, 32), 
							"noshow", 
							B_DOCUMENT_WINDOW, 
							/*B_WILL_ACCEPT_FIRST_CLICK*/0);
				BView bv(BRect(0, 0, 32, 32), "noView", B_FOLLOW_NONE, B_WILL_DRAW);
				bwn.AddChild(&bv);
				bv.SetFont(myPrefs->GetPreferredFont());
				float stringEntryPixWidth = bv.StringWidth("Put some string data here:");
				bv.RemoveSelf();
				BMessage * pStringGadgetMsg = new BMessage(DEMOSTRINGGADGMSG);
				StringGadget * pholdStringGadget = new StringGadget(	BRect(0, 0, 32, 32), 
																"stringGadgetName", 
																"Put some string data here:", 
																NULL, 
																pStringGadgetMsg, 
																B_FOLLOW_NONE, 
																B_WILL_DRAW | B_NAVIGABLE,
																stringEntryPixWidth);
				pholdStringGadget->SetFont(myPrefs->GetPreferredFont());
				kindDemo = KIND_STRINGGADG;
				pholdDemo = (void *)pholdStringGadget;
			break;
			}
			case SPECIFIC_COLOR_COLORWELL:
			{
				TextItem * pholdText = new TextItem("A roColor ColorWell ");
				addMeToDraw = (void *)pholdText;
				ColorWell * pholdColorWell = new ColorWell(	"colorWell", 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		NO_COLOR,
																		pholdText);
				kindDemo = KIND_COLORWELLGADG;
				pholdDemo = (void *)pholdColorWell;
			break;
			}
			case SPECIFIC_COLOR_STRINGDRAWER:
			{
				BFont * pBFont = new BFont(myPrefs->GetPreferredFont());
				MyStringDrawer * pholdMyStringDrawer = new MyStringDrawer(	"stringDrawer", 
																			"This is how your text will look!", 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			pBFont);
				//pMyStringDrawer->SetFont(myPrefs->GetPreferredFont());
				kindDemo = KIND_STRINGDRAWER;
				pholdDemo = (void *)pholdMyStringDrawer;
			break;
			}
			default:
				warning("Specific item bad kind.\n");
				throw;
			break;
		}
		pholdDemoLayoutMatrix->AddToChildren(pholdDemo);
		pmDemoItem = pholdDemo;
		if (addMeToDraw)
		{
			pholdDemoLayoutMatrix->AddToDraw(addMeToDraw);
		}
		auto_ptr<LayoutMatrixItem> apDemoLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																				pholdDemo, 
																				pholdDemoLayoutMatrix->itemsList,
																				kindDemo));
//////////////////////////////////
		release_sem(calc_sem);
		pholdTitleLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		pholdViewCCLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pholdTitleLayoutMatrix->bottom, calc_sem);
		pholdHighCCLayoutMatrix->Calc(pholdViewCCLayoutMatrix->right, pholdTitleLayoutMatrix->bottom, calc_sem);
		pholdLowCCLayoutMatrix->Calc(pholdHighCCLayoutMatrix->right, pholdTitleLayoutMatrix->bottom, calc_sem);
		pholdColorWellLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pholdLowCCLayoutMatrix->bottom, calc_sem);
		pholdDemoLayoutMatrix->Calc(pholdLowCCLayoutMatrix->right, pholdTitleLayoutMatrix->bottom, calc_sem);
	}
	catch (...)
	{
		warning("caught specific color window constructor\n");
		release_sem(calc_sem);
		throw;
	}
	BMenuItem *	menuItem;
	BMenu *		APPMenu = new BMenu("app");
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(ABOUT_SPECIFICCOLORFWINDOW));
		menuItem = new BMenuItem(	"About...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	APPMenu->AddItem(menuItem);
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(B_QUIT_REQUESTED));
		menuItem = new BMenuItem(	"Close window", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	APPMenu->AddItem(menuItem);
	pMenuBar->AddItem(APPMenu);
}//end


//dtor
SpecificColorWindow	::	~SpecificColorWindow() 
{
	if (myPrefs->pPrefPanelWindow)//can get a race if not checked
	{
		myPrefs->pPrefPanelWindow->mpPrefWindows[kind] = NULL;
	}
}//end


bool
SpecificColorWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	rgb_color viewColor(pmViewColorControl->ValueAsColor());
	rgb_color highColor(pmHighColorControl->ValueAsColor());
	rgb_color lowColor(pmLowColorControl->ValueAsColor());
	switch (kind) 
	{
		case SPECIFIC_COLOR_BUTTON:
			myPrefs->SetPreferredSpecificColorButtonWindowRect(frame);
			myPrefs->SetPreferredMyButtonViewColor(&viewColor);
			myPrefs->SetPreferredMyButtonHighColor(&highColor);
			myPrefs->SetPreferredMyButtonLowColor(&lowColor);
		break;
		case SPECIFIC_COLOR_PICTURE:
			myPrefs->SetPreferredSpecificColorPictureButtonWindowRect(frame);
			myPrefs->SetPreferredMyPictureButtonViewColor(&viewColor);
			myPrefs->SetPreferredMyPictureButtonHighColor(&highColor);
			myPrefs->SetPreferredMyPictureButtonLowColor(&lowColor);
		break;
		case SPECIFIC_COLOR_RADIOVIEW:
			myPrefs->SetPreferredSpecificColorRadioButtonWindowRect(frame);
			myPrefs->SetPreferredMyRadioViewViewColor(&viewColor);
			myPrefs->SetPreferredMyRadioViewHighColor(&highColor);
			myPrefs->SetPreferredMyRadioViewLowColor(&lowColor);
		break;
		case SPECIFIC_COLOR_CHECKBOX:
			myPrefs->SetPreferredSpecificColorCheckBoxWindowRect(frame);
			myPrefs->SetPreferredMyCheckBoxViewColor(&viewColor);
			myPrefs->SetPreferredMyCheckBoxHighColor(&highColor);
			myPrefs->SetPreferredMyCheckBoxLowColor(&lowColor);
		break;
		case SPECIFIC_COLOR_STATUSBAR:
			myPrefs->SetPreferredSpecificColorStatusBarWindowRect(frame);
			myPrefs->SetPreferredMyStatusBarViewColor(&viewColor);
			myPrefs->SetPreferredMyStatusBarHighColor(&highColor);
			myPrefs->SetPreferredMyStatusBarLowColor(&lowColor);
		break;
		case SPECIFIC_COLOR_COLORCONTROL:
			myPrefs->SetPreferredSpecificColorColorControlWindowRect(frame);
			myPrefs->SetPreferredMyColorControlViewColor(&viewColor);
			myPrefs->SetPreferredMyColorControlHighColor(&highColor);
			myPrefs->SetPreferredMyColorControlLowColor(&lowColor);
		break;
		case SPECIFIC_COLOR_TEXTVIEW:
			myPrefs->SetPreferredSpecificColorTextViewWindowRect(frame);
			myPrefs->SetPreferredMyTextViewViewColor(&viewColor);
			myPrefs->SetPreferredMyTextViewHighColor(&highColor);
			myPrefs->SetPreferredMyTextViewLowColor(&lowColor);
		break;
		case SPECIFIC_COLOR_INTGADG:
			myPrefs->SetPreferredSpecificColorIntGadgetWindowRect(frame);
			myPrefs->SetPreferredIntGadgetViewColor(&viewColor);
			myPrefs->SetPreferredIntGadgetHighColor(&highColor);
			myPrefs->SetPreferredIntGadgetLowColor(&lowColor);
		break;
		case SPECIFIC_COLOR_STRINGGADG:
			myPrefs->SetPreferredSpecificColorStringGadgetWindowRect(frame);
			myPrefs->SetPreferredStringGadgetViewColor(&viewColor);
			myPrefs->SetPreferredStringGadgetHighColor(&highColor);
			myPrefs->SetPreferredStringGadgetLowColor(&lowColor);
		break;
		case SPECIFIC_COLOR_COLORWELL:
			myPrefs->SetPreferredSpecificColorColorWellWindowRect(frame);
			myPrefs->SetPreferredColorWellViewColor(&viewColor);
			myPrefs->SetPreferredColorWellHighColor(&highColor);
			myPrefs->SetPreferredColorWellLowColor(&lowColor);
		break;
		case SPECIFIC_COLOR_STRINGDRAWER:
			myPrefs->SetPreferredSpecificColorStringDrawerWindowRect(frame);
			myPrefs->SetPreferredMyStringDrawerViewColor(&viewColor);
			myPrefs->SetPreferredMyStringDrawerHighColor(&highColor);
			myPrefs->SetPreferredMyStringDrawerLowColor(&lowColor);
		break;
		default:
			warning("Bad specific color kind QuitRequested.");
			throw;
		break;
	}
	return(WindowGuts::QuitRequested());
}//end


void
SpecificColorWindow	::	ResetDemo(	void)
{
	myPrefs->bPrefChangesMade = true;
	rgb_color viewColor(pmViewColorControl->ValueAsColor());
	rgb_color highColor(pmHighColorControl->ValueAsColor());
	rgb_color lowColor(pmLowColorControl->ValueAsColor());
	Lock();
	((BButton *)pmDemoItem)->SetViewColor(viewColor);
	((BButton *)pmDemoItem)->SetHighColor(highColor);
	((BButton *)pmDemoItem)->SetLowColor(lowColor);
	((BButton *)pmDemoItem)->Draw(((BButton *)pmDemoItem)->Bounds());
	Unlock();
}//end


void
SpecificColorWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case ABOUT_SPECIFICCOLORFWINDOW:	
			warning("about specific color window\n");
		break;
		case COLORCONTROL_VIEW:
		case COLORCONTROL_HIGH:
		case COLORCONTROL_LOW:
			ResetDemo();
		break;
		case ROCOLORDROPPEDMESSAGE: 
		{
    		rgb_color * pRGBColor;
    		rgb_color color;    		
    		int32 numRGBBytes = sizeof(struct rgb_color);
	        if (	pparamMessage->FindData(	"RGBColor",
		       									B_RGB_COLOR_TYPE, 
												(void**)&pRGBColor, 
												&numRGBBytes ) 
					== B_OK)
	        {
	           	color = *pRGBColor;
	            if (pparamMessage->WasDropped()) 
	            { 
					int32 colorToChange;
					if (	pparamMessage->FindInt32(	"ColorToChange",
														&colorToChange)
							 == B_OK)
					{
						switch(colorToChange)
						{
							case VIEW_COLOR:
								switch(kind)
								{
									case SPECIFIC_COLOR_BUTTON:
										myPrefs->SetPreferredMyButtonViewColor(&color);
									break;
									case SPECIFIC_COLOR_PICTURE:
										myPrefs->SetPreferredMyPictureButtonViewColor(&color);
									break;
									case SPECIFIC_COLOR_RADIOVIEW:
										myPrefs->SetPreferredMyRadioViewViewColor(&color);
									break;
									case SPECIFIC_COLOR_CHECKBOX:
										myPrefs->SetPreferredMyCheckBoxViewColor(&color);
									break;
									case SPECIFIC_COLOR_STATUSBAR:
										myPrefs->SetPreferredMyStatusBarViewColor(&color);
									break;
									case SPECIFIC_COLOR_COLORCONTROL:
										myPrefs->SetPreferredMyColorControlViewColor(&color);
									break;
									case SPECIFIC_COLOR_TEXTVIEW:
										myPrefs->SetPreferredMyTextViewViewColor(&color);
									break;
									case SPECIFIC_COLOR_INTGADG:
										myPrefs->SetPreferredIntGadgetViewColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGGADG:
										myPrefs->SetPreferredStringGadgetViewColor(&color);
									break;
									case SPECIFIC_COLOR_COLORWELL:
										myPrefs->SetPreferredColorWellViewColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGDRAWER:
										myPrefs->SetPreferredMyStringDrawerViewColor(&color);
									break;
									default:
										warning("Bad kind specific color set view\n");
										throw;
									break;
								}
								pmViewColorControl->SetValue(color);
							break;
							case HIGH_COLOR:
								switch(kind)
								{
									case SPECIFIC_COLOR_BUTTON:
										myPrefs->SetPreferredMyButtonHighColor(&color);
									break;
									case SPECIFIC_COLOR_PICTURE:
										myPrefs->SetPreferredMyPictureButtonHighColor(&color);
									break;
									case SPECIFIC_COLOR_RADIOVIEW:
										myPrefs->SetPreferredMyRadioViewHighColor(&color);
									break;
									case SPECIFIC_COLOR_CHECKBOX:
										myPrefs->SetPreferredMyCheckBoxHighColor(&color);
									break;
									case SPECIFIC_COLOR_STATUSBAR:
										myPrefs->SetPreferredMyStatusBarHighColor(&color);
									break;
									case SPECIFIC_COLOR_COLORCONTROL:
										myPrefs->SetPreferredMyColorControlHighColor(&color);
									break;
									case SPECIFIC_COLOR_TEXTVIEW:
										myPrefs->SetPreferredMyTextViewHighColor(&color);
									break;
									case SPECIFIC_COLOR_INTGADG:
										myPrefs->SetPreferredIntGadgetHighColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGGADG:
										myPrefs->SetPreferredStringGadgetHighColor(&color);
									break;
									case SPECIFIC_COLOR_COLORWELL:
										myPrefs->SetPreferredColorWellHighColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGDRAWER:
										myPrefs->SetPreferredMyStringDrawerHighColor(&color);
									break;
									default:
										warning("Bad kind specific color set high\n");
										throw;
									break;
								}
								pmHighColorControl->SetValue(color);
							break;
							case LOW_COLOR:
								switch(kind)
								{
									case SPECIFIC_COLOR_BUTTON:
										myPrefs->SetPreferredMyButtonLowColor(&color);
									break;
									case SPECIFIC_COLOR_PICTURE:
										myPrefs->SetPreferredMyPictureButtonLowColor(&color);
									break;
									case SPECIFIC_COLOR_RADIOVIEW:
										myPrefs->SetPreferredMyRadioViewLowColor(&color);
									break;
									case SPECIFIC_COLOR_CHECKBOX:
										myPrefs->SetPreferredMyCheckBoxLowColor(&color);
									break;
									case SPECIFIC_COLOR_STATUSBAR:
										myPrefs->SetPreferredMyStatusBarLowColor(&color);
									break;
									case SPECIFIC_COLOR_COLORCONTROL:
										myPrefs->SetPreferredMyColorControlLowColor(&color);
									break;
									case SPECIFIC_COLOR_TEXTVIEW:
										myPrefs->SetPreferredMyTextViewLowColor(&color);
									break;
									case SPECIFIC_COLOR_INTGADG:
										myPrefs->SetPreferredIntGadgetLowColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGGADG:
										myPrefs->SetPreferredStringGadgetLowColor(&color);
									break;
									case SPECIFIC_COLOR_COLORWELL:
										myPrefs->SetPreferredColorWellLowColor(&color);
									break;
									case SPECIFIC_COLOR_STRINGDRAWER:
										myPrefs->SetPreferredMyStringDrawerLowColor(&color);
									break;
									default:
										warning("Bad kind specific color set low\n");
										throw;
									break;
								}
								pmLowColorControl->SetValue(color);
							break;
							case NO_COLOR:
								warning("Demo roColorWell does not make any changes!\n");
							break;
							default:
								warning("roColor sent basic a bad colorToChange\n");
								//debug throw;
							break;
						}
						ResetDemo();
					}
				}
			}
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end