//scrolling prefPanel window


#include "windowGuts.h"
#include <memory>
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "fontPrefWindow.h"
#include "specificColorWindow.h"
#include "myCheckBox.h"
#include "basicColorWindow.h"
#include "prefPanelWindow.h"
#include "warning.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"

#define PREFPANEL_COLOR_BASIC 'pcb '
#define PREFPANEL_COLOR_BUTTON 'pcbb'
#define PREFPANEL_COLOR_RADIOVIEW 'pcrv'
#define PREFPANEL_COLOR_STRINGDRAWER 'pcsp'
#define PREFPANEL_COLOR_CHECKBOX 'pccb'
#define PREFPANEL_COLOR_PICTURE 'pcp '
#define PREFPANEL_COLOR_COLORCONTROL 'pccc'
#define PREFPANEL_COLOR_STATUSBAR 'pcsb'
#define PREFPANEL_COLOR_INTGADG 'pcig'
#define PREFPANEL_COLOR_STRINGGADG 'pcsg'
#define PREFPANEL_COLOR_COLORWELL 'pccw'
#define PREFPANEL_COLOR_TEXTVIEW 'pctv'
#define PREFPANEL_FONTS 'pfnt'

uint32 buttonMessages[NUMPREFPANELS] =
{
	PREFPANEL_COLOR_BASIC,
	PREFPANEL_COLOR_BUTTON,
	PREFPANEL_COLOR_PICTURE,
	PREFPANEL_COLOR_RADIOVIEW,
	PREFPANEL_COLOR_CHECKBOX,
	PREFPANEL_COLOR_STATUSBAR,
	PREFPANEL_COLOR_COLORCONTROL,
	PREFPANEL_COLOR_TEXTVIEW,
	PREFPANEL_COLOR_INTGADG,
	PREFPANEL_COLOR_STRINGGADG,
	PREFPANEL_COLOR_COLORWELL,
	PREFPANEL_COLOR_STRINGDRAWER
};

const char * buttonLabels[] =
{
	"Underlying view...",
	"Button...",
	"Picture Button...",
	"Radio Buttons...",
	"CheckBox...",
	"StatusBar...",
	"Color Control...",
	"Text View...",
	"Integer Gadget...",
	"String Gadget...",
	"RoColor ColorWell...",
	"String Draw..."
};
const char * buttonNames[] =
{
	"underlying",
	"button",
	"picture Button",
	"radiobuttons",
	"checkBox",
	"statusBar",
	"colorControl",
	"textview",
	"integerGaXdg",
	"stringGadget",
	"roColorColorWell",
	"stringDraw",
};

//ctor
PrefPanelWindow	::	PrefPanelWindow(	BRect	paramBound,
										const char *	ccpparamWindowTitle,
										const char *	ccpparamScrollViewName,
										const char *	ccpparamNamePrefFrame)
				: 
				WindowGuts(	paramBound, 
							ccpparamWindowTitle, 
							ccpparamScrollViewName,
							ccpparamNamePrefFrame),
				mpFontPrefWindow(NULL)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning("Could not create_sem.\n");
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		for (uint32 i = 0; i < NUMPREFPANELS; i++)
		{
			mpPrefWindows[i] = NULL;
		}
		BWindow bw(	BRect(0, 0, 32, 32), 
					"noshow", 
					B_DOCUMENT_WINDOW, 
					/*B_WILL_ACCEPT_FIRST_CLICK*/0);
//////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apTitleLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 3, 1));//rows,columns
		LayoutMatrix *	pholdTitleLayoutMatrix = apTitleLayoutMatrix.get();
		apTitleLayoutMatrix.release();
		AddToLayoutMatrixList(pholdTitleLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apBFont(new BFont());//note-- using system be_plain_font
		BFont * pBFont = apBFont.get();//NOT preferredFont(), just for something different
		apBFont.release();
		float fontSize = pBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pBFont->SetSize(fontSize);
		pBFont->SetShear(122);
		auto_ptr<MyStringDrawer> apMyStringDrawer(new MyStringDrawer(	"prefPanelMyStringDrawer", 
																		"General Preferences", 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFont));
		MyStringDrawer * pMyStringDrawer = apMyStringDrawer.get();
		apMyStringDrawer.release();
		pholdTitleLayoutMatrix->AddToChildren((void *)pMyStringDrawer);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pMyStringDrawer, 
																							pholdTitleLayoutMatrix->itemsList,
																							KIND_STRINGDRAWER));
//////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> fontMsg(new BMessage(PREFPANEL_FONTS));
		auto_ptr<MyButton> apFontMyButton(new MyButton(	"localFontButton", 
																	"Font...", 
																	fontMsg.get(), 
																	B_FOLLOW_NONE, 
																	B_WILL_DRAW));
		fontMsg.release();
		MyButton * pholdFontMyButton = apFontMyButton.get();
		apFontMyButton.release();
		pholdFontMyButton->SetFont(myPrefs->GetPreferredFont());
		pholdTitleLayoutMatrix->AddToChildren((void *)pholdFontMyButton);
		auto_ptr<LayoutMatrixItem> apFontMyButtonLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pholdFontMyButton, 
																							pholdTitleLayoutMatrix->itemsList,
																							KIND_MYBUTTON));
/////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apBFontColor(new BFont(pBFont));//note-- using previous font
		BFont * pBFontColor = apBFontColor.get();
		apBFontColor.release();
		auto_ptr<MyStringDrawer> apColorMyStringDrawer(new MyStringDrawer(	"prefPanelColorMyStringDrawer", 
																			"Interface Color Preferences", 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			pBFontColor));
		MyStringDrawer * pColorMyStringDrawer = apColorMyStringDrawer.get();
		apColorMyStringDrawer.release();
		pholdTitleLayoutMatrix->AddToChildren((void *)pColorMyStringDrawer);
		auto_ptr<LayoutMatrixItem> apColorMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)pColorMyStringDrawer, 
																								pholdTitleLayoutMatrix->itemsList,
																								KIND_STRINGDRAWER));
//////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apCheckLayoutMatrix(new LayoutMatrix(&bw, SAMESIZE, 1, 2));//rows,columns
		LayoutMatrix *	pholdCheckLayoutMatrix = apCheckLayoutMatrix.get();
		apCheckLayoutMatrix.release();
		AddToLayoutMatrixList(pholdCheckLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
		BMessage * displayCCMsg = new BMessage(DISPLAY_CC);
		mpDisplayColorControlCheckBox = new MyCheckBox(	"displayCC", 
															"Display BColorControls", 
															displayCCMsg, 
															B_FOLLOW_NONE, 
															B_WILL_DRAW);
		mpDisplayColorControlCheckBox->SetFont(myPrefs->GetPreferredFont());
		pholdCheckLayoutMatrix->AddToChildren((void *)mpDisplayColorControlCheckBox);
		LayoutMatrixItem * displayCCLayoutMatrixItem = new LayoutMatrixItem(	&bw, 
																				(void *)mpDisplayColorControlCheckBox, 
																				pholdCheckLayoutMatrix->itemsList,
																				KIND_MYCHECKBOX);
		mpDisplayColorControlCheckBox->SetValue(myPrefs->bUseColorControl);
//////////////////////////////////////////////////////////////////////////////////////
		BMessage * displayCWMsg = new BMessage(DISPLAY_CW);
		mpDisplayColorWellCheckBox = new MyCheckBox(	"displayCW", 
															"Display roColor wells", 
															displayCWMsg, 
															B_FOLLOW_NONE, 
															B_WILL_DRAW);
		mpDisplayColorWellCheckBox->SetFont(myPrefs->GetPreferredFont());
		pholdCheckLayoutMatrix->AddToChildren((void *)mpDisplayColorWellCheckBox);
		LayoutMatrixItem * displayCWLayoutMatrixItem = new LayoutMatrixItem(	&bw, 
																				(void *)mpDisplayColorWellCheckBox, 
																				pholdCheckLayoutMatrix->itemsList,
																				KIND_MYCHECKBOX);
		mpDisplayColorWellCheckBox->SetValue(myPrefs->bUseColorWell);
//////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<LayoutMatrix> apPrefPanelLayoutMatrix(new LayoutMatrix(&bw, SAMESIZE, 4, 3));//rows,columns
		LayoutMatrix *	pholdPrefPanelLayoutMatrix = apPrefPanelLayoutMatrix.get();
		apPrefPanelLayoutMatrix.release();
		AddToLayoutMatrixList(pholdPrefPanelLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////
		{
			LayoutMatrixItem * layoutMatrixItem[NUMPREFPANELS];
			for (uint32 iButton = 0; iButton < NUMPREFPANELS; iButton++)
			{
				BMessage * buttonMsg = new BMessage(buttonMessages[iButton]);
				MyButton * button = new MyButton(	buttonNames[iButton], 
															buttonLabels[iButton], 
															buttonMsg, 
															B_FOLLOW_NONE, 
															B_WILL_DRAW);
				button->SetFont(myPrefs->GetPreferredFont());
				pholdPrefPanelLayoutMatrix->AddToChildren((void *)button);
				layoutMatrixItem[iButton] = new LayoutMatrixItem(	&bw, 
																	(void *)button, 
																	pholdPrefPanelLayoutMatrix->itemsList,
																	KIND_MYBUTTON);
			}
		}
///////////////////////////
		release_sem(calc_sem);
		pholdTitleLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		pholdCheckLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pholdTitleLayoutMatrix->bottom, calc_sem);
		pholdPrefPanelLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pholdCheckLayoutMatrix->bottom, calc_sem);		
	}
	catch (...)
	{
		warning("caught font panel window constructor\n");
		release_sem(calc_sem);
		throw;
	}
	BMenuItem *	menuItem;
	BMenu *		APPMenu = new BMenu("app");
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(ABOUT_PREFPANELWINDOW));
		menuItem = new BMenuItem(	"About...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	APPMenu->AddItem(menuItem);
	
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(B_QUIT_REQUESTED));
		menuItem = new BMenuItem(	"Close window", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	APPMenu->AddItem(menuItem);
	pMenuBar->AddItem(APPMenu);
}//end


//dtor
PrefPanelWindow	::	~PrefPanelWindow() 
{
	if (be_app)//this check is almost for sure not needed!
	{
		myPrefs->pPrefPanelWindow = NULL;
	}
}//end


void
PrefPanelWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case PREFPANEL_COLOR_BASIC://debug might re-enroll this case by simply adding a demo item to it
			OpenBasicColorPanel();//makes all windows equal and greatly simplifies things--see version .2 <smile>
		break;
		case PREFPANEL_FONTS:
			OpenFontPanel();
		break;
		case PREFPANEL_COLOR_BUTTON://debug check math relationship between PREFPANEL_COLOR_BUTTON
			OpenSpecificColorPanel(SPECIFIC_COLOR_BUTTON);//and SPECIFIC_COLOR_BUTTON
		break;						//might roll all rest into a single pparamMessage->what case+/-1
		case PREFPANEL_COLOR_RADIOVIEW:
			OpenSpecificColorPanel(SPECIFIC_COLOR_RADIOVIEW);
		break;
		case PREFPANEL_COLOR_STRINGDRAWER:
			OpenSpecificColorPanel(SPECIFIC_COLOR_STRINGDRAWER);
		break;
		case PREFPANEL_COLOR_CHECKBOX:
			OpenSpecificColorPanel(SPECIFIC_COLOR_CHECKBOX);
		break;
		case PREFPANEL_COLOR_PICTURE:
			OpenSpecificColorPanel(SPECIFIC_COLOR_PICTURE);
		break;
		case PREFPANEL_COLOR_COLORCONTROL:
			OpenSpecificColorPanel(SPECIFIC_COLOR_COLORCONTROL);
		break;
		case PREFPANEL_COLOR_STATUSBAR:
			OpenSpecificColorPanel(SPECIFIC_COLOR_STATUSBAR);
		break;
		case PREFPANEL_COLOR_INTGADG:
			OpenSpecificColorPanel(SPECIFIC_COLOR_INTGADG);
		break;
		case PREFPANEL_COLOR_STRINGGADG:
			OpenSpecificColorPanel(SPECIFIC_COLOR_STRINGGADG);
		break;
		case PREFPANEL_COLOR_COLORWELL:
			OpenSpecificColorPanel(SPECIFIC_COLOR_COLORWELL);
		break;
		case PREFPANEL_COLOR_TEXTVIEW:
			OpenSpecificColorPanel(SPECIFIC_COLOR_TEXTVIEW);
		break;
		case ABOUT_PREFPANELWINDOW:	
			warning("about preference panel window\n");
		break;
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
PrefPanelWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myPrefs->SetPreferredPrefPanelWindowRect(frame);
	myPrefs->bUseColorWell = mpDisplayColorWellCheckBox->Value();
	myPrefs->bUseColorControl = mpDisplayColorControlCheckBox->Value();
	for (uint32 i = 0; i < NUMPREFPANELS; i++)
	{
		if (mpPrefWindows[i])
		{
			mpPrefWindows[i]->PostMessage(B_QUIT_REQUESTED);
		}
	}
	return(WindowGuts::QuitRequested());
}//end


void
PrefPanelWindow	::	OpenFontPanel(void)
{
	if (mpFontPrefWindow)
	{
		mpFontPrefWindow->Activate(true);
	}
	else
	{
		try 
		{
			BRect holdRect;
			myPrefs->GetPreferredFontPrefWindowRect(&holdRect);
			auto_ptr<FontPrefWindow> apPrefWindow(new FontPrefWindow(	holdRect,
																		"fontPrefWindow",
																		"Font preferences",
																		"FontPrefFrame"));
			mpFontPrefWindow = apPrefWindow.get();
			apPrefWindow.release();
			mpFontPrefWindow->Initialize();
		}
		catch (...) 
		{
			warning("No new font preference window.\n");
			throw;
		}
	}
}//end


void
PrefPanelWindow	::	OpenBasicColorPanel(void)
{
	if (mpPrefWindows[PP_BASIC])
	{
		mpPrefWindows[PP_BASIC]->Activate(true);
	}
	else
	{
		try 
		{
			BRect holdRect;
			myPrefs->GetPreferredBasicColorWindowRect(&holdRect);
			auto_ptr<BasicColorWindow> apBasicColorWindow(new BasicColorWindow(	holdRect,
																				"basicColorWindow",
																				"Basic view colors",
																				"FontPrefFrame"));
			mpPrefWindows[PP_BASIC] = apBasicColorWindow.get();
			apBasicColorWindow.release();
			mpPrefWindows[PP_BASIC]->Initialize();
		}
		catch (...) 
		{
			warning("No new basic view color preference window.\n");
			throw;
		}
	}
}//end


void
PrefPanelWindow	::	OpenSpecificColorPanel(uint32 whichOne)
{
	if (mpPrefWindows[whichOne + 1])//whichOne references an array with button at zero
	{			//mpPrefWindows[] is an array with basic at zero and button at one
		mpPrefWindows[whichOne + 1]->Activate(true);//debug dump plus one in ver .2 <smile>
	}
	else
	{
		try 
		{
			BRect holdRect;
			switch (whichOne)
			{
				case SPECIFIC_COLOR_BUTTON:
					myPrefs->GetPreferredSpecificColorButtonWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_PICTURE:
					myPrefs->GetPreferredSpecificColorPictureButtonWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_RADIOVIEW:
					myPrefs->GetPreferredSpecificColorRadioButtonWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_CHECKBOX:
					myPrefs->GetPreferredSpecificColorCheckBoxWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_STATUSBAR:
					myPrefs->GetPreferredSpecificColorStatusBarWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_COLORCONTROL:
					myPrefs->GetPreferredSpecificColorColorControlWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_TEXTVIEW:
					myPrefs->GetPreferredSpecificColorTextViewWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_INTGADG:
					myPrefs->GetPreferredSpecificColorIntGadgetWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_STRINGGADG:
					myPrefs->GetPreferredSpecificColorStringGadgetWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_COLORWELL:
					myPrefs->GetPreferredSpecificColorColorWellWindowRect(&holdRect);
				break;
				case SPECIFIC_COLOR_STRINGDRAWER:
					myPrefs->GetPreferredSpecificColorStringDrawerWindowRect(&holdRect);
				break;
			}
			auto_ptr<SpecificColorWindow> apBasicColorWindow(new SpecificColorWindow(	holdRect,
																				whichOne));
			mpPrefWindows[whichOne] = apBasicColorWindow.get();
			apBasicColorWindow.release();
			mpPrefWindows[whichOne]->Initialize();
		}
		catch (...) 
		{
			warning("No new specific color preference window.\n");
			throw;
		}
	}
}//end