//functions of MyTextView

#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"
#include "myTextView.h"
#include "layoutMatrix.h"


MyTextView	::	~MyTextView() 
{
//left blank
};//end


//ctor--just initialize
MyTextView	::	MyTextView(	const char *	ccpparamName, 
							const char *	ccpparamText,
							float 			fparamMaxWidth,
							float			fparamMaxHeight) 
				: 
					BTextView(	BRect(0,0,fparamMaxWidth,fparamMaxHeight), 
								ccpparamName, 
								BRect(1,1,fparamMaxWidth + 1,fparamMaxWidth + 1), 
								B_FOLLOW_NONE, 
								B_WILL_DRAW),
					fmWidth(fparamMaxWidth),
					fmHeight(fparamMaxHeight)
{
	SetText(ccpparamText);
	MakeResizable(false);
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyTextViewHighColor(&tempRgbColor);
	SetFontAndColor(myPrefs->GetPreferredFont(), B_FONT_ALL, &tempRgbColor);
}//end


void 
MyTextView	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyTextViewViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end


void
MyTextView	::	MyGetPreferredSize(	float * fpparamwidth,
									float * fpparamheight)
{
	*fpparamheight = fmHeight;
	*fpparamwidth = fmWidth;
}//end