//MyApp.cpp

#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"
#include "myButton.h"
#include "stringGadget.h"
#include "intGadget.h"
#include "warning.h"
#include "fontData.h"
#include "layoutMatrix.h"
#include "colorWell.h"
#include "myColorControl.h"
#include "myTextView.h"
#include "windowGuts.h"
#include "myCheckBox.h"
#include "prefPanelWindow.h"
#include "mainWindow.h"
#include "zipWindow.h"
#include <memory>


MyApp	::	MyApp()
		:	BApplication("application/x-EFM5-GUIZip"),
			pMainWindow(NULL),
			pZipWindow(NULL)
{
	BRect windowPrefArea;
	const void * windowPrefAreaData;
	size_t windowPrefAreaSize;
	uint32 windowPrefAreaType = '    ';
	if (	appsPreferenceSet.GetData(	"GUIZipMainFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		BRect	screenResolutionRect;
		{//if screen is on stack do I want it in app's scope, or should I do like this so it goes away fast?
			BScreen	screen(B_MAIN_SCREEN_ID);
			if(!screen.IsValid()) 
			{//may not be valid, if not, this is not a critical app--bail out as best we can
				puts("!screen.IsValid()");
				exit(3);
			}
			screenResolutionRect = screen.Frame();
		}
		windowPrefArea.Set(	5,
					22, 
					screenResolutionRect.right - 17,
					screenResolutionRect.bottom - 37);
					//the - 17 and - 37 were determined based upon trial and error
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredGUIZipWindowRect(windowPrefArea);
	if (	appsPreferenceSet.GetData(	"GUIZipZipFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		BRect	screenResolutionRect;
		{//if screen is on stack do I want it in app's scope, or should I do like this so it goes away fast?
			BScreen	screen(B_MAIN_SCREEN_ID);
			if(!screen.IsValid()) 
			{//may not be valid, if not, this is not a critical app--bail out as best we can
				puts("!screen.IsValid()");
				exit(5);
			}
			screenResolutionRect = screen.Frame();
		}
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
							//the - 17 and - 37 were determined based upon trial and error
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredZipWindowRect(windowPrefArea);
}//end


MyApp	::	~MyApp() 
{
//left blank
}//end


//all apps will need a main window to display on launch
void 
MyApp	::	ReadyToRun(				void) 
{
	try 
	{
		BRect holdRect;
		GetPreferredGUIZipWindowRect(&holdRect);
		auto_ptr<MainWindow> apMainWindow(new MainWindow(	holdRect,
															"GUIZip by Ed Musgrove #2076",
															"mainScrollView",
															"GUIZipMainFrame"));
		pMainWindow = apMainWindow.get();
		apMainWindow.release();
		pMainWindow->Initialize();
	}
	catch (...) 
	{
		warning("No new ScrollingGUIZipWindow\n");
		be_app->PostMessage(new BMessage(B_QUIT_REQUESTED));
	}
}//end


void 
MyApp	::	MessageReceived(		BMessage *	message) 
{
	switch(message->what)
	{
		case REOPEN_MAIN:
		{
			try 
			{
				uint32 i = 0;
				bool canDo = true;
				if (pMainWindow) 
				{
					do
					{
						snooze(TINYSNOOZE);
						i++;
						if (i == TINYSNOOZE)
						{
							canDo = false;
							warning("Major problem, main window not NULL.\n");
							be_app->PostMessage(new BMessage(B_QUIT_REQUESTED));
						}
					} 
					while (pMainWindow && canDo);
				}
				if (canDo) 
				{
					BRect holdRect;
					GetPreferredGUIZipWindowRect(&holdRect);
					auto_ptr<MainWindow> apMainWindow(new MainWindow(	holdRect,
																		"GUIZip by Ed Musgrove #2076",
																		"mainScrollView",
																		"GUIZipMainFrame"));
					pMainWindow = apMainWindow.get();
					apMainWindow.release();
					pMainWindow->Initialize();
				}
			}
			catch (...)
			{
				warning("No renewed ScrollingGUIZipWindow\n");
				be_app->PostMessage(new BMessage(B_QUIT_REQUESTED));
			}
		break;
		}
		case 0:	//I am wondering about this
				//it only shows up when app is launched from 
				//tracker and resources are present in the file
				//when run via double-click on the app icon I get a message here
				//with a message->what == zero
			warning("_item_to_launch_ received--message->what == zero\n");
		break;
		default:
			//I don't expect any msgs here
			if (message->what) beep();
			BApplication::MessageReceived(message);
		break;
	}
}//end


void
MyApp	::	GetPreferredGUIZipWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredGUIZipWindowRect;
}//end


void
MyApp	::	SetPreferredGUIZipWindowRect(	const BRect paramWindowRect)
{
	preferredGUIZipWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredZipWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredZipWindowRect;
}//end


void
MyApp	::	SetPreferredZipWindowRect(	const BRect paramWindowRect)
{
	preferredZipWindowRect = paramWindowRect;
}//end

void
MyApp	::  OpenZipPanel(	void)
{
	if (pZipWindow)
	{
		pZipWindow->Activate(true);
	}
	else
	{
		try 
		{
			BRect holdRect;
			GetPreferredZipWindowRect(&holdRect);
			auto_ptr<ZipWindow> apZipWindow(new ZipWindow(	holdRect,
															"GUIZip Zip",
															"GUIZip Zip scroll view",
															"GUIZipZipFrame"));
			pZipWindow = apZipWindow.get();
			apZipWindow.release();
			pZipWindow->Initialize();
		}
		catch (...) 
		{
			warning("No new Zip window.\n");
			return;
		}
	}
}//end


void
MyApp	::  OpenUnzipPanel(	void)
{
	warning("unzip will appear in the future\n");
}//end