#include <memory>
#include "intGadget.h"
#include "stringGadget.h"
#include "warning.h"
#include "colorWell.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myStatusBar.h"
#include "myPopUpMenu.h"
#include "myTextView.h"
#include "myRadioView.h"
#include "layoutMatrixItem.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myApp.h"

//dtor
LayoutMatrixItem	::	~LayoutMatrixItem()
{
//left blank
}


//ctor
LayoutMatrixItem	::	LayoutMatrixItem(	BWindow * paramWindow, 
											void * paramItem, 
											BList * pparamMatrixItemList,
											const uint32 paramKind) 
					: 	window(paramWindow), 
						item(paramItem), 
						kind(paramKind),
						last(false)
{
	pparamMatrixItemList->AddItem(this);
}//end


//calculates the minimum appropriate width and height
//of a matrix item
void 
LayoutMatrixItem	::	Calc(	const BFont *	paramFont) 
{
	const float pad = 11;
	//use pad to give a bit of room at each end of the
	//button to set off the button text
	BRect br(0, 0, 32, 32);
	BView view(br, "LayoutMatrixItem temp view", B_FOLLOW_NONE, B_WILL_DRAW);
	//need to attach these items to a BView before they can be measured
	window->AddChild(&view);
	if (paramFont) 
	{
		view.SetFont(paramFont);
	}
	//set the view's font so the buttons will inherit them
	//when size is checked
	switch (kind) 
	{
		case KIND_STRINGDRAWER:
		{
			view.AddChild((BStringView *)item);
			view.SetFont(((MyStringDrawer *)item)->GetFont());
			float labelWidth = pad + view.StringWidth(((BStringView *)item)->Text());
			if (paramFont)
			{
				view.SetFont(paramFont);
			}
			((MyStringDrawer *)item)->MyGetPreferredSize(&widthPref, &heightPref);
			//PreferredSize uses a huge pad--I dislike the wasted space
			//so I compute labelWidth plus some small padding...
			if (labelWidth > widthPref) 
			{
				widthPref = labelWidth;
			}
			else 
			{
				labelWidth = widthPref;
			}
			//then use the smaller width--might be good to perform
			//the same opperation for height, though the preferred 
			//height seems OK
			((BStringView *)item)->ResizeTo(labelWidth, heightPref);
			view.RemoveChild((BStringView *)item);
		break;
		}
		case KIND_MYPOPUPMENU:
			((MyPopUpMenu *)item)->MyGetPreferredSize(&widthPref, &heightPref);
		break;
		case KIND_MYTEXTVIEW:
			((MyPopUpMenu *)item)->MyGetPreferredSize(&widthPref, &heightPref);
		break;
		case KIND_MYBUTTON: 
		{
			view.AddChild((BButton *)item);
//			font_height	fontHeight;
//			view.GetFontHeight(&fontHeight);
//			float labelHeight = pad + fontHeight.ascent + fontHeight.descent + fontHeight.leading;
			float labelWidth = pad + view.StringWidth(((BButton *)item)->Label());
			((BButton *)item)->GetPreferredSize(&widthPref, &heightPref);
			//PreferredSize uses a huge pad--I dislike the wasted space
			//so I compute labelWidth plus some small padding...
//			if (labelWidth > widthPref) 
//			{
//				widthPref = labelWidth;
//			}
//			else 
//			{
//				labelWidth = widthPref;
//			}
//			//then use the smaller width--might be good to perform
//			//the same opperation for height, though the preferred 
//			//height seems OK--though the more I look less I like
//			//the height--debug
//			if (labelHeight > heightPref) 
//			{
//				heightPref = labelHeight;
//			}
//			else 
//			{
//				labelHeight = heightPref;
//			}
			((BButton *)item)->ResizeTo(labelWidth, heightPref);
			view.RemoveChild((BButton *)item);
		break;
		}
		case KIND_MYCHECKBOX: 
		{
			view.AddChild((BCheckBox *)item);
			float labelWidth = pad + view.StringWidth(((BCheckBox *)item)->Label());
			((BCheckBox *)item)->GetPreferredSize(&widthPref, &heightPref);
			//PreferredSize uses a huge pad--I dislike the wasted space
			//so I compute labelWidth plus some small padding...
			if (labelWidth > widthPref) 
			{
				widthPref = labelWidth;
			}
			else 
			{
				labelWidth = widthPref;
			}
			//then use the smaller width--might be good to perform
			//the same opperation for height, though the preferred 
			//height seems OK
			((BCheckBox *)item)->ResizeTo(labelWidth, heightPref);
			view.RemoveChild((BCheckBox *)item);
		break;
		}
		case KIND_MYSTATUSBAR: 
		{
			view.AddChild((BStatusBar *)item);
			((MyStatusBar *)item)->MyGetPreferredSize(&widthPref, &heightPref);
			((BStatusBar *)item)->ResizeTo(widthPref, heightPref);
			view.RemoveChild((BStatusBar *)item);
		break;
		}
		case KIND_MYPICTUREBUTTON: 
		{
			view.AddChild((BPictureButton *)item);
			float labelWidth = pad + view.StringWidth(((BPictureButton *)item)->Label());
			((BPictureButton *)item)->GetPreferredSize(&widthPref, &heightPref);
			//PreferredSize uses a huge pad--I dislike the wasted space
			//so I compute labelWidth plus some small padding...
			if (labelWidth > widthPref) 
			{
				widthPref = labelWidth;
			}
			else 
			{
				labelWidth = widthPref;
			}
			//then use the smaller width--might be good to perform
			//the same opperation for height, though the preferred 
			//height seems OK
			((BPictureButton *)item)->ResizeTo(labelWidth, heightPref);
			view.RemoveChild((BPictureButton *)item);
		break;
		}
		case KIND_MYCOLORCONTROL: 
		{
			view.AddChild((BColorControl *)item);
			((BColorControl *)item)->GetPreferredSize(&widthPref, &heightPref);
//			float fontSize = myPrefs->GetPreferredFont()->Size();
//			((BColorControl *)item)->ResizeBy(fontSize * 5.8, fontSize * 1.5);
//			int32 children = ((BColorControl *)item)->CountChildren();
//			BView * tbv;
//			for (int32 i = 0; i < children; i++)
//			{
//				tbv = ((BColorControl *)item)->ChildAt(i);
//				tbv->SetFont(myPrefs->GetPreferredFont());
//				tbv->ResizeToPreferred();
//			}
//			widthPref = ((BColorControl *)item)->Bounds().Width();
//			heightPref = ((BColorControl *)item)->Bounds().Height();
			view.RemoveChild((BColorControl *)item);
		break;
		}
		case KIND_MYRADIOVIEW: 
		{
			view.AddChild((MyRadioView *)item);
			((MyRadioView *)item)->GetPreferredSize(&widthPref, &heightPref);
			view.RemoveChild((MyRadioView *)item);
		break;
		}
		case KIND_INTGADG: 
		{
			view.AddChild((IntGadget *)item);
			float labelWidth = pad + view.StringWidth(((IntGadget *)item)->Label());
			((IntGadget *)item)->GetPreferredSize(&widthPref, &heightPref);
			((IntGadget *)item)->SetDivider(labelWidth);
			float inputWidth = view.StringWidth("0404040404");
			widthPref = labelWidth + inputWidth;
			((IntGadget *)item)->ResizeTo(widthPref, heightPref);
			BView * child = ((BView *)item)->ChildAt(0);
			float excess = 20;//debug calculate??
			child->ResizeBy(0, heightPref - excess);
			child->SetFont(paramFont);//doesn't do any good
			view.RemoveChild((IntGadget *)item);
		break;
		}
		
		case KIND_STRINGGADG: 
		{
			view.AddChild((StringGadget *)item);
			float labelWidth = pad + view.StringWidth(((StringGadget *)item)->Label());
			((StringGadget *)item)->GetPreferredSize(&widthPref, &heightPref);
			((StringGadget *)item)->SetDivider(labelWidth);
			widthPref = labelWidth + ((StringGadget *)item)->mfPixWidth;
			((StringGadget *)item)->ResizeTo(widthPref, heightPref);
			view.RemoveChild((StringGadget *)item);
		break;
		}
		case KIND_TEXT: 
		{
			widthPref = pad + view.StringWidth(((TextItem *)item)->text);
			font_height	fontHeight;
			view.GetFontHeight(&fontHeight);
			heightPref = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
		break;
		}
		case KIND_COLORWELLGADG: 
		{
			font_height	fontHeight;
			view.GetFontHeight(&fontHeight);
			float totalHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
			((ColorWell *)item)->descender = (fontHeight.ascent - fontHeight.descent) / 2;
			if (COLORWELLHEIGHT > totalHeight)
			{
				heightPref = COLORWELLHEIGHT;
			}
			else
			{
				heightPref = totalHeight;
			}
			((ColorWell *)item)->SetTop(heightPref);//store this temp value until time to really place item
			widthPref = pad + view.StringWidth((((ColorWell *)item)->GetTextItem())->text) + heightPref;
			((ColorWell *)item)->SetLeft(widthPref - heightPref - pad);//store this temp value until time to really place item
			float framing = ((ColorWell *)item)->Frame().Width();
			int32 int32Framing = ((ColorWell *)item)->Frame().IntegerWidth();
			if (framing > heightPref)
			{
				if (!(int32Framing % 2))
				{
					framing--;
				}
				((ColorWell *)item)->ResizeTo(framing, framing);
			}
			else
			{
				int32 int32HeightPref = heightPref;
				if (!(int32HeightPref % 2))
				{
					heightPref--;
				}
				((ColorWell *)item)->ResizeTo(heightPref, heightPref);
			}
		break;
		}
	}
	window->RemoveChild(&view);
}//end