//scrolling fontPref window


#include "windowGuts.h"
#include <memory>
#include <string>
#include "s2f.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "intGadget.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myCheckBox.h"
#include "myPopUpMenu.h"
#include "myCheckBox.h"
#include "prefPanelWindow.h"
#include "fontPrefWindow.h"
#include "fontDisplayWindow.h"
#include "warning.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"

//ctor
FontPrefWindow	::	FontPrefWindow(	BRect	paramBound,
									const char *	ccpparamWindowTitle,
									const char *	ccpparamScrollViewName,
									const char *	ccpparamNamePrefFrame)
				: 
				WindowGuts(	paramBound, 
							ccpparamWindowTitle, 
							ccpparamScrollViewName,
							ccpparamNamePrefFrame),
				mpFontDisplayWindow(NULL)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning("Could not create_sem.\n");
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		BWindow bw(	BRect(0, 0, 32, 32), 
					"noshow", 
					B_DOCUMENT_WINDOW, 
					/*B_WILL_ACCEPT_FIRST_CLICK*/0);
		auto_ptr<LayoutMatrix> apFontPrefWindowLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 5, 1));//rows,columns
		LayoutMatrix *	pholdFontPrefWindowLayoutMatrix = apFontPrefWindowLayoutMatrix.get();
		apFontPrefWindowLayoutMatrix.release();
		AddToLayoutMatrixList(pholdFontPrefWindowLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apBFont(new BFont());//note-- using system be_plain_font
		BFont * pBFont = apBFont.get();//NOT preferredFont(), just for something different
		apBFont.release();
		float fontSize = pBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pBFont->SetSize(fontSize);
		pBFont->SetShear(122);
		//calc font height for offset of PUMs--you could use a seperate matrix and get it's bottom
		float pumOffset;
		{
			BView view(BRect(0, 0, 32, 32), "LayoutMatrixView", B_FOLLOW_NONE, B_WILL_DRAW);
			bw.AddChild(&view);
			view.SetFont(pBFont);
			font_height	fontHeight;
			view.GetFontHeight(&fontHeight);
			pumOffset = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
			view.RemoveSelf();
		}
		auto_ptr<MyStringDrawer> apMyStringDrawer(new MyStringDrawer(	"fontPrefMyStringDrawer", 
																		"Font Preferences", 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFont));
		MyStringDrawer * pMyStringDrawer = apMyStringDrawer.get();
		apMyStringDrawer.release();
		pMyStringDrawer->SetFont(myPrefs->GetPreferredFont());
		pholdFontPrefWindowLayoutMatrix->AddToChildren((void *)pMyStringDrawer);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pMyStringDrawer, 
																							pholdFontPrefWindowLayoutMatrix->itemsList,
																							KIND_STRINGDRAWER));
////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> bigFontMsg(new BMessage(BIGGER_FONT));
		auto_ptr<MyButton> apBiggerFontMyButton(new MyButton(	"localBiggerFontButton", 
																			"Bigger font", 
																			bigFontMsg.get(), 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW));
		bigFontMsg.release();
		MyButton * pholdBiggerFontMyButton = apBiggerFontMyButton.get();
		apBiggerFontMyButton.release();
		pholdBiggerFontMyButton->SetFont(myPrefs->GetPreferredFont());
		pholdFontPrefWindowLayoutMatrix->AddToChildren((void *)pholdBiggerFontMyButton);
		auto_ptr<LayoutMatrixItem> apBiggerFontMyButtonLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																									(void *)pholdBiggerFontMyButton, 
																									pholdFontPrefWindowLayoutMatrix->itemsList,
																									KIND_MYBUTTON));
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> smallFontMsg(new BMessage(SMALLER_FONT));
		auto_ptr<MyButton> apSmallerFontMyButton(new MyButton(	"localSmallerFontButton", 
																			"Smaller font", 
																			smallFontMsg.get(),
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW));
		smallFontMsg.release();
		MyButton * pholdSmallerFontMyButton = apSmallerFontMyButton.get();
		apSmallerFontMyButton.release();
		pholdSmallerFontMyButton->SetFont(myPrefs->GetPreferredFont());
		pholdFontPrefWindowLayoutMatrix->AddToChildren((void *)pholdSmallerFontMyButton);
		auto_ptr<LayoutMatrixItem> apSmallerFontMyButtonLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																									(void *)pholdSmallerFontMyButton, 
																									pholdFontPrefWindowLayoutMatrix->itemsList,
																									KIND_MYBUTTON));
//////////////////////////////////////////////////////////////////
	char fontSizeStr[16];
	sprintf(fontSizeStr, "%f", myPrefs->GetPreferredFont()->Size());
	auto_ptr<BMessage> apFontSizeMsg(new BMessage(FONT_SIZE_STR));
	auto_ptr<IntGadget> apFontSizeIntGadget(new IntGadget(	BRect(10, 100, 300, 110), 
														"FontSizeIntGadget", 
														"Enter font size", 
														fontSizeStr, 
														apFontSizeMsg.get(), 
														B_FOLLOW_NONE, 
														B_WILL_DRAW | B_NAVIGABLE));
	apFontSizeMsg.release();
	IntGadget * pholdIntGadget = (IntGadget *)apFontSizeIntGadget.get();
	apFontSizeIntGadget.release();
	pholdIntGadget->SetFont(myPrefs->GetPreferredFont());
	pholdFontPrefWindowLayoutMatrix->AddToChildren((void *)pholdIntGadget);
	auto_ptr<LayoutMatrixItem> apFontSizeLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																				(void *)pholdIntGadget, 
																				pholdFontPrefWindowLayoutMatrix->itemsList,
																				KIND_INTGADG));
	mpSizeIntGadget = pholdIntGadget;
//////////////////////////////////////////////////////////////////
			BMessage * displayFontMsg = new BMessage(DISPLAY_FONT);
			mpDisplayFontCheckBox = new MyCheckBox(	"displayFont", 
														"Display font", 
														displayFontMsg, 
														B_FOLLOW_NONE, 
														B_WILL_DRAW);
			mpDisplayFontCheckBox->SetFont(myPrefs->GetPreferredFont());
			pholdFontPrefWindowLayoutMatrix->AddToChildren((void *)mpDisplayFontCheckBox);
			LayoutMatrixItem * displayFontLayoutMatrixItem = new LayoutMatrixItem(	&bw, 
																					(void *)mpDisplayFontCheckBox, 
																					pholdFontPrefWindowLayoutMatrix->itemsList,
																					KIND_MYCHECKBOX);
			mpDisplayFontCheckBox->SetValue(myPrefs->bOpenFontDisplay);
/////////////////////
		auto_ptr<LayoutMatrix> apPUMLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 2, 1));//rows,columns
		LayoutMatrix *	pholdPUMLayoutMatrix = apPUMLayoutMatrix.get();
		apPUMLayoutMatrix.release();
		AddToLayoutMatrixList(pholdPUMLayoutMatrix);
//////////////////////
	BList * pumbl = new BList();
	PopUpMenuData  * pumd1[10];
	const char * testIt[10] =
	{
		"test 11",
		"test 12",
		"test 13",
		"test 14",
		"test 15",
		"test 16",
		"test 17",
		"test 18",
		"test 19",
		"test 120"
	};
	for (uint32 i = 0; i < 10; i++)
	{
		pumd1[i] = new PopUpMenuData();
		pumd1[i]->ui32mMsg = i;
		pumd1[i]->ccpmLabel = testIt[i];
		pumbl->AddItem((void *)pumd1[i]);
	}
	MyPopUpMenu * pum1 = new MyPopUpMenu("fontFamilyPUM", "current font, eventually :)", pumbl, true);
	bool success = pum1->Initialize();
	if (!success) 
	{
		warning("PopUpMenu failed Initialize() for font Window./n");
	}
	pholdPUMLayoutMatrix->AddToChildren((void *)pum1);
	auto_ptr<LayoutMatrixItem> apPUM1LayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pum1, 
																					pholdPUMLayoutMatrix->itemsList,
																					KIND_MYPOPUPMENU));
///////////////////////////////////////////////////////////////////////////
	BList * pumb2 = new BList();
	PopUpMenuData  * pumd2[5];
	const char * testIt2[5] =
	{
		"style 11",
		"style 12",
		"style 13",
		"style 14",
		"style 15"
	};
	for (uint32 i = 0; i < 5; i++)
	{
		pumd2[i] = new PopUpMenuData();
		pumd2[i]->ui32mMsg = i;
		pumd2[i]->ccpmLabel = testIt2[i];
		pumb2->AddItem((void *)pumd2[i]);
	}
	MyPopUpMenu * pum2 = new MyPopUpMenu("fontStylePUM", "font style, soon??", pumb2, false);
	success = pum2->Initialize();
	if (!success) 
	{
		warning("PopUpMenu failed Initialize() for font Window./n");
	}
	pholdPUMLayoutMatrix->AddToChildren((void *)pum2);
	auto_ptr<LayoutMatrixItem> apPUM2tMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pum2, 
																					pholdPUMLayoutMatrix->itemsList,
																					KIND_MYPOPUPMENU));
/////////////////////////////////////////////////////
		release_sem(calc_sem);
		pholdFontPrefWindowLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		pholdPUMLayoutMatrix->Calc(pholdFontPrefWindowLayoutMatrix->right, MATRIXVERTICALOFFSET + pumOffset, calc_sem);
	}
	catch (...)
	{
		warning("caught font preference window constructor\n");
		release_sem(calc_sem);
		throw;
	}
	BMenuItem *	menuItem;
	BMenu *		APPMenu = new BMenu("app");
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(ABOUT_FONTPREFWINDOW));
		menuItem = new BMenuItem(	"About...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	APPMenu->AddItem(menuItem);
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(B_QUIT_REQUESTED));
		menuItem = new BMenuItem(	"Close window", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	APPMenu->AddItem(menuItem);
	pMenuBar->AddItem(APPMenu);
	OpenFontDisplayWindow();
}//end


//dtor
FontPrefWindow	::	~FontPrefWindow() 
{
	delete[] mpcFullLine;
	if (mpFontDisplayWindow)
	{
		mpFontDisplayWindow->PostMessage(B_QUIT_REQUESTED);
	}
	if (myPrefs->pPrefPanelWindow)//can get a race if not checked
	{
		myPrefs->pPrefPanelWindow->mpFontPrefWindow = NULL;
	}
	//close all panels
}//end


void
FontPrefWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case BIGGER_FONT:
		case SMALLER_FONT:
		{
	       	float oldSize = (myPrefs->GetPreferredFont())->Size();
			if (pparamMessage->what == BIGGER_FONT) 
			{
				oldSize++;
			}
			else
			{
				oldSize--;
			}
			ResetFontSize(oldSize);
		break;
		}
		case FONT_SIZE_STR:
		{
			ResetFontSize(s2f(mpSizeIntGadget->Text()));
		break;
		}
//		case DISPLAY_FONT:
//		break;
		case ABOUT_FONTPREFWINDOW:	
		{
			warning("about font preference window\n");
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
FontPrefWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myPrefs->SetPreferredFontPrefWindowRect(frame);
	myPrefs->bOpenFontDisplay = mpDisplayFontCheckBox->Value();
	return(WindowGuts::QuitRequested());
}//end


void
FontPrefWindow	::	OpenFontDisplayWindow(void)
{
	uint32 i = 0;
	bool canDo = true;
	if (mpFontDisplayWindow) 
	{
		do
		{
			snooze(TINYSNOOZE);
			if (i++ == TINYSNOOZE)
			{
				canDo = false;
				warning("Major problem, font display window not NULL.\n");
				be_app->PostMessage(new BMessage(B_QUIT_REQUESTED));
			}
		} 
		while (mpFontDisplayWindow && canDo);
	}
	if (canDo) 
	{
		BWindow bw(	BRect(0, 0, 32, 32), 
					"noshow", 
					B_DOCUMENT_WINDOW, 
					/*B_WILL_ACCEPT_FIRST_CLICK*/0);
		BView view(BRect(0, 0, 32, 32), "LayoutMatrixView", B_FOLLOW_NONE, B_WILL_DRAW);
		bw.AddChild(&view);
		view.SetFont(myPrefs->GetPreferredFont());
		font_height	fontHeight;
		view.GetFontHeight(&fontHeight);
		float heightPref = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
		string sFullLine = "";
		uint32 asciiStart = 48;
		for (uint32 i = 0; i < 10; i++)
		{
			sFullLine += (i + asciiStart);
		}
		asciiStart = 65;
		uint32 j = 10;
		for (uint32 i = 0; i < 26; i++, j++)
		{
			sFullLine += (i + asciiStart);
		}
		asciiStart = 97;
		j = 36;
		for (uint32 i = 0; i < 26; i++, j++)
		{
			sFullLine += (i + asciiStart);
		}
		view.RemoveSelf();
		try 
		{
			mpcFullLine = new char[strlen(sFullLine.c_str()) + 1];
			strcpy(mpcFullLine, sFullLine.c_str());
			BRect holdRect;
			myPrefs->GetPreferredFontDisplayWindowRect(&holdRect);
			auto_ptr<FontDisplayWindow> apFontDisplayWindow(new FontDisplayWindow(	holdRect,
																					"FontDisplayWindow",
																					"Font Display Window",
																					"FontDisplayWindowFrame",
																					mpcFullLine));
			mpFontDisplayWindow = apFontDisplayWindow.get();
			apFontDisplayWindow.release();
			mpFontDisplayWindow->Initialize();
		}
		catch (...) 
		{
			warning("No new font display window.\n");
			throw;
		}
	}
}//end


void
FontPrefWindow	::	ResetFontSize(	float newSize)
{
	myPrefs->bPrefChangesMade = true;
	char fontSizeStr[16];
	if (newSize < 1)
	{
		warning("Font must remain above 0, sorry.\n");
		sprintf(fontSizeStr, "%f", myPrefs->GetPreferredFont()->Size());
		mpSizeIntGadget->SetText(fontSizeStr);
	}
	else if (newSize > 51000)
	{
		warning("Font must remain below 51000, sorry.\n");
		sprintf(fontSizeStr, "%f", myPrefs->GetPreferredFont()->Size());
		mpSizeIntGadget->SetText(fontSizeStr);
	}
	else
	{
		myPrefs->GetPreferredFont()->SetSize(newSize);
		sprintf(fontSizeStr, "%f", myPrefs->GetPreferredFont()->Size());
		mpSizeIntGadget->SetText(fontSizeStr);
	}
	if (myPrefs->bOpenFontDisplay) 
	{
		if (mpFontDisplayWindow)
		{
			mpFontDisplayWindow->Lock();
			if (mpFontDisplayWindow->IsHidden())
			{
				do
				{
					mpFontDisplayWindow->Show();
				} while (mpFontDisplayWindow->IsHidden());
			}
			mpFontDisplayWindow->Unlock();
		}
		else
		{
			OpenFontDisplayWindow();
		}
	}
	else
	{
		if (mpFontDisplayWindow)
		{
			mpFontDisplayWindow->PostMessage(B_QUIT_REQUESTED);
		}
	}
}//end
			