//
// CalcView.h
//

#pragma once

#include <View.h>
#include "Calculator.h"

class CalcView : public BView
{
public:
	CalcView(BWindow* parent);
	CalcView(BView* parent);
	CalcView(BWindow* parent, BRect frame);
	CalcView(BView* parent, BRect frame);
	void KeyDown(const char* bytes, int32 numBytes);
	void MessageReceived(BMessage *message);
	
protected:
	void Construct();
	void CreateDisplay();
	void CreateButtons();
	BButton* CreateDigitButton(float left, float top, const char* digit);
	void CreateMenus();
	BButton* CreateOperatorButton(BRect r, const char* name, 
		const char* label, int32 command);
	void CreateRadixGroup();
	void EnableButtons(Calculator::RADIX radix);
	void HandleDigit(BMessage* msg);
	void HandleOperator(BMessage* msg);
	void SetRadix(BMessage* message);
	void UpdateDisplay();
	
private:
	Calculator	calc;
};

#define DV_DIGIT_BTN	'vdgt'
#define DV_CLEAR_ALL	'clra'
#define DV_CLEAR		'cler'
#define DV_OPERATOR		'oper'
#define DV_UNARY_MINUS	'umin'
#define DV_DEC			'rdec'
#define DV_HEX			'rhex'
#define DV_OCT			'roct'
#define DV_BIN			'rbin'
#define DV_OP_NOT		'onot'

